/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.action;

import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.nls.query.TranslationKeysQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQueryResult;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsReferenceProvider;
import org.eclipse.scout.sdk.s2e.ui.internal.nls.editor.NlsTableController;
import org.eclipse.scout.sdk.s2e.util.EclipseWorkspaceWalker;
import org.eclipse.swt.widgets.Display;

public class UpdateReferenceCountAction
extends Action {
    private final NlsTableController m_controller;
    private final Display m_display;

    public UpdateReferenceCountAction(NlsTableController controller, Display display) {
        this.m_controller = controller;
        this.m_display = display;
        this.setText("Show Translation Key usage");
        this.setImageDescriptor(S2ESdkUiActivator.getImageDescriptor("find_obj.gif"));
    }

    public void run() {
        this.setEnabled(false);
        EclipseWorkspaceWalker.executeQuery((IFileQuery)new TranslationKeysQuery(this.m_controller.stack(), this.getText())).whenComplete(this::handleEndSearch);
    }

    private void handleEndSearch(Supplier<IFileQueryResult> query, Throwable error) {
        this.m_display.asyncExec(() -> this.handleEndSearchInUi(query, error));
    }

    private void handleEndSearchInUi(Supplier<IFileQueryResult> supplier, Throwable error) {
        if (error == null) {
            TranslationKeysQuery query = (TranslationKeysQuery)supplier.get();
            this.m_controller.setReferenceProvider(new NlsReferenceProvider(query.resultByKey()));
        } else if (error instanceof CancellationException || error instanceof OperationCanceledException) {
            SdkLog.debug((String)"Reference count calculation cancelled.", (Object[])new Object[]{error});
        } else {
            SdkLog.error((String)"Error during reference count calculation.", (Object[])new Object[]{error});
        }
        this.setEnabled(true);
    }
}

