/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.search;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.s.nls.TranslationStoreStack;
import org.eclipse.scout.sdk.core.s.nls.query.TranslationKeysQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQueryResult;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;
import org.eclipse.scout.sdk.s2e.util.EclipseWorkspaceWalker;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;

public class NlsFindKeyQuery
extends FileSearchQuery {
    private final String m_nlsKey;
    private final TranslationStoreStack m_project;

    public NlsFindKeyQuery(TranslationStoreStack project, String nlsKey) {
        super("", false, false, null);
        this.m_project = project;
        this.m_nlsKey = nlsKey;
    }

    public String getResultLabel(int matches) {
        return "References to the text key '" + this.getNlsKey() + "' (" + matches + ").";
    }

    public String getLabel() {
        return "Find references to the text key '" + this.getNlsKey() + "'...";
    }

    public FileSearchResult getSearchResult() {
        return (FileSearchResult)super.getSearchResult();
    }

    public IStatus run(IProgressMonitor monitor) {
        IFileQueryResult query = EclipseWorkspaceWalker.executeQuerySync((IFileQuery)new TranslationKeysQuery(this.getNlsKey(), this.getLabel()), (IProgressMonitor)monitor);
        S2eUiUtils.queryResultToSearchResult(query, this.getSearchResult());
        return Status.OK_STATUS;
    }

    public String getNlsKey() {
        return this.m_nlsKey;
    }

    public TranslationStoreStack getProject() {
        return this.m_project;
    }
}

