/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.ast.DefaultAstVisitor;
import org.eclipse.scout.sdk.s2e.util.ast.ITypeBindingVisitor;

public final class AstUtils {
    private AstUtils() {
    }

    public static Deque<ASTNode> getChildren(ASTNode node) {
        P_ChildrenCollector visitor = new P_ChildrenCollector();
        node.accept((ASTVisitor)visitor);
        return visitor.m_result;
    }

    public static IType getTypeBinding(AbstractTypeDeclaration td) {
        ITypeBinding binding = td.resolveBinding();
        if (binding == null) {
            return null;
        }
        IJavaElement javaElement = binding.getJavaElement();
        if (!JdtUtils.exists(javaElement) || javaElement.getElementType() != 7) {
            return null;
        }
        return (IType)javaElement;
    }

    public static Type getInnerTypeReturnType(SimpleName innerTypeSimpleName, TypeDeclaration innerTypeDeclaringType) {
        AST ast = innerTypeSimpleName.getAST();
        Deque<TypeDeclaration> declaringTypes = AstUtils.getDeclaringTypes(innerTypeDeclaringType);
        if (AstUtils.hasTypeParametersInDeclaringTypes(declaringTypes)) {
            Type type = null;
            Iterator<TypeDeclaration> topDownIterator = declaringTypes.descendingIterator();
            while (topDownIterator.hasNext()) {
                type = AstUtils.wrapParameterizedIfRequired(topDownIterator.next(), type);
            }
            if (type != null) {
                return ast.newQualifiedType(type, innerTypeSimpleName);
            }
        }
        return ast.newSimpleType((Name)innerTypeSimpleName);
    }

    private static Type wrapParameterizedIfRequired(TypeDeclaration template, Type type) {
        AST ast = template.getAST();
        SimpleName sn = ast.newSimpleName(template.getName().getIdentifier());
        type = type == null ? ast.newSimpleType((Name)sn) : ast.newQualifiedType(type, sn);
        if (template.typeParameters().isEmpty()) {
            return type;
        }
        ParameterizedType parameterizedType = ast.newParameterizedType(type);
        for (int i = 0; i < template.typeParameters().size(); ++i) {
            parameterizedType.typeArguments().add(ast.newWildcardType());
        }
        return parameterizedType;
    }

    private static boolean hasTypeParametersInDeclaringTypes(Iterable<TypeDeclaration> declaringTypes) {
        for (TypeDeclaration td : declaringTypes) {
            if (td.typeParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Object getBindingResolver(AST ast) {
        try {
            Method getBindingResolver = AST.class.getDeclaredMethod("getBindingResolver", new Class[0]);
            getBindingResolver.setAccessible(true);
            return getBindingResolver.invoke((Object)ast, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public static CompilationUnitScope getCompilationUnitScope(Object resolver) {
        try {
            Method scope = resolver.getClass().getDeclaredMethod("scope", new Class[0]);
            scope.setAccessible(true);
            return (CompilationUnitScope)scope.invoke(resolver, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException t) {
            throw new SdkException((Throwable)t);
        }
    }

    public static void addAnnotationTo(Annotation a, BodyDeclaration owner) {
        ASTNode sibling = AstUtils.getAnnotationSibling(owner, a);
        if (sibling != null) {
            int insertPos = owner.modifiers().indexOf(sibling);
            owner.modifiers().add(insertPos, a);
        } else {
            owner.modifiers().add(a);
        }
    }

    public static Deque<TypeDeclaration> getDeclaringTypes(TypeDeclaration start) {
        ArrayDeque<TypeDeclaration> result = new ArrayDeque<TypeDeclaration>();
        if (start == null) {
            return result;
        }
        result.add(start);
        TypeDeclaration parent = start;
        while ((parent = (TypeDeclaration)AstUtils.getParent((ASTNode)parent, 55)) != null) {
            result.add(parent);
        }
        return result;
    }

    public static Deque<Annotation> getAnnotations(BodyDeclaration owner) {
        ArrayDeque<Annotation> annotations = new ArrayDeque<Annotation>();
        for (Object o : owner.modifiers()) {
            if (!(o instanceof Annotation)) continue;
            annotations.add((Annotation)o);
        }
        return annotations;
    }

    public static String createMethodIdentifier(MethodDeclaration md) {
        List parameters = md.parameters().stream().map(SingleVariableDeclaration::getType).map(ASTNode::toString).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier((CharSequence)md.getName().getIdentifier(), parameters);
    }

    public static ASTNode getAnnotationSibling(BodyDeclaration owner, Annotation newAnnotation) {
        Deque<Annotation> annotations = AstUtils.getAnnotations(owner);
        if (!annotations.isEmpty()) {
            int newAnnotLen = newAnnotation.toString().length();
            Iterator<Annotation> iterator = annotations.descendingIterator();
            while (iterator.hasNext()) {
                Annotation existingAnnotation = iterator.next();
                int len = existingAnnotation.getLength();
                if (len <= 0 || len < newAnnotLen) continue;
                return existingAnnotation;
            }
        }
        for (Object o : owner.modifiers()) {
            if (!(o instanceof Modifier)) continue;
            return (ASTNode)o;
        }
        return null;
    }

    public static boolean isInstanceOf(ITypeBinding hierarchyType, String fqn) {
        if (hierarchyType == null) {
            return false;
        }
        if (fqn == null) {
            return false;
        }
        P_InstanceOfBindingVisitor visitor = new P_InstanceOfBindingVisitor(fqn);
        AstUtils.visitHierarchy(hierarchyType, visitor);
        return visitor.m_isFound;
    }

    public static boolean visitHierarchy(ITypeBinding type, ITypeBindingVisitor visitor) {
        HashSet<ITypeBinding> visited = new HashSet<ITypeBinding>();
        return AstUtils.visitBindingRec(type, visitor, visited);
    }

    private static boolean visitBindingRec(ITypeBinding type, ITypeBindingVisitor visitor, Set<ITypeBinding> visited) {
        boolean unvisited = visited.add(type);
        if (!unvisited) {
            return true;
        }
        if (!visitor.visit(type)) {
            return false;
        }
        ITypeBinding superclass = type.getSuperclass();
        if (superclass != null && !AstUtils.visitBindingRec(superclass, visitor, visited)) {
            return false;
        }
        return Arrays.stream(type.getInterfaces()).allMatch(ifc -> AstUtils.visitBindingRec(ifc, visitor, visited));
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static ASTNode getNextNode(ASTNode n, int pos, Predicate<ASTNode> filter) {
        return AstUtils.getSiblingNode(n, pos, filter, false);
    }

    public static ASTNode getPreviousNode(ASTNode n, int pos, Predicate<ASTNode> filter) {
        return AstUtils.getSiblingNode(n, pos, filter, true);
    }

    private static ASTNode getSiblingNode(ASTNode n, int pos, Predicate<ASTNode> filter, boolean prev) {
        Deque<ASTNode> children = AstUtils.getChildren(n);
        Iterator<ASTNode> iterator = prev ? children.descendingIterator() : children.iterator();
        while (iterator.hasNext()) {
            ASTNode currentNode = iterator.next();
            int endOfCurrentNode = currentNode.getStartPosition() + currentNode.getLength();
            boolean bl = prev ? endOfCurrentNode < pos : pos < endOfCurrentNode;
            boolean isRangeOk = bl;
            if (!isRangeOk || filter != null && !filter.test(currentNode)) continue;
            return currentNode;
        }
        return null;
    }

    public static String getFullyQualifiedName(TypeDeclaration type) {
        return AstUtils.getFullyQualifiedName(type, null);
    }

    public static String getFullyQualifiedName(TypeDeclaration type, TypeDeclaration declaringType) {
        return AstUtils.getFullyQualifiedName(type, declaringType, '$');
    }

    public static String getFullyQualifiedName(TypeDeclaration type, char innerTypeSeparator) {
        return AstUtils.getFullyQualifiedName(type, null, innerTypeSeparator);
    }

    public static String getFullyQualifiedName(TypeDeclaration type, TypeDeclaration declaringType, char innerTypeSeparator) {
        ASTNode root = type.getRoot();
        if (root instanceof CompilationUnit) {
            Deque<TypeDeclaration> parentTypes = AstUtils.getDeclaringTypes(type);
            return AstUtils.getFullyQualifiedName(parentTypes, (CompilationUnit)root, innerTypeSeparator);
        }
        StringBuilder sb = new StringBuilder();
        if (declaringType != null) {
            sb.append(AstUtils.getFullyQualifiedName(declaringType, null, innerTypeSeparator));
        }
        Deque<TypeDeclaration> declaringTypes = AstUtils.getDeclaringTypes(type);
        for (TypeDeclaration td : declaringTypes) {
            sb.append(innerTypeSeparator).append(td.getName().getIdentifier());
        }
        return sb.toString();
    }

    public static String getFullyQualifiedName(Deque<TypeDeclaration> parentTypes, CompilationUnit cu) {
        return AstUtils.getFullyQualifiedName(parentTypes, cu, '$');
    }

    public static String getFullyQualifiedName(Deque<TypeDeclaration> parentTypes, CompilationUnit cu, char innerTypeSeparator) {
        Iterator<TypeDeclaration> descendingIterator;
        StringBuilder fqnBuilder = new StringBuilder();
        PackageDeclaration pck = cu.getPackage();
        if (pck != null) {
            fqnBuilder.append(pck.getName()).append('.');
        }
        if ((descendingIterator = parentTypes.descendingIterator()).hasNext()) {
            fqnBuilder.append(descendingIterator.next().getName());
            while (descendingIterator.hasNext()) {
                fqnBuilder.append(innerTypeSeparator).append(descendingIterator.next().getName());
            }
        }
        return fqnBuilder.toString();
    }

    private static final class P_ChildrenCollector
    extends DefaultAstVisitor {
        private Deque<ASTNode> m_result = null;

        private P_ChildrenCollector() {
            super(true);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            if (this.m_result == null) {
                this.m_result = new ArrayDeque<ASTNode>();
                return true;
            }
            this.m_result.add(node);
            return false;
        }
    }

    private static final class P_InstanceOfBindingVisitor
    implements ITypeBindingVisitor {
        private final String m_fqnToSearch;
        private boolean m_isFound;

        private P_InstanceOfBindingVisitor(String fqnToSearch) {
            this.m_fqnToSearch = fqnToSearch;
            this.m_isFound = false;
        }

        @Override
        public boolean visit(ITypeBinding type) {
            if (this.m_fqnToSearch.equals(type.getTypeDeclaration().getQualifiedName())) {
                this.m_isFound = true;
                return false;
            }
            return true;
        }
    }
}

