/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.PlanPro.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.PlanPro.util.PlanProAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class PlanProItemProviderAdapterFactory extends PlanProAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlanProItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Adresse_PLZ_Ort_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Adresse_PLZ_Ort_TypeClassItemProvider adresse_PLZ_Ort_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Adresse_PLZ_Ort_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdresse_PLZ_Ort_TypeClassAdapter() {
		if (adresse_PLZ_Ort_TypeClassItemProvider == null) {
			adresse_PLZ_Ort_TypeClassItemProvider = new Adresse_PLZ_Ort_TypeClassItemProvider(this);
		}

		return adresse_PLZ_Ort_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Adresse_Strasse_Nr_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Adresse_Strasse_Nr_TypeClassItemProvider adresse_Strasse_Nr_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Adresse_Strasse_Nr_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdresse_Strasse_Nr_TypeClassAdapter() {
		if (adresse_Strasse_Nr_TypeClassItemProvider == null) {
			adresse_Strasse_Nr_TypeClassItemProvider = new Adresse_Strasse_Nr_TypeClassItemProvider(this);
		}

		return adresse_Strasse_Nr_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AkteurItemProvider akteurItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkteurAdapter() {
		if (akteurItemProvider == null) {
			akteurItemProvider = new AkteurItemProvider(this);
		}

		return akteurItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akteur_Allg_AttributeGroupItemProvider akteur_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkteur_Allg_AttributeGroupAdapter() {
		if (akteur_Allg_AttributeGroupItemProvider == null) {
			akteur_Allg_AttributeGroupItemProvider = new Akteur_Allg_AttributeGroupItemProvider(this);
		}

		return akteur_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Akteur_ZuordnungItemProvider akteur_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Akteur_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAkteur_ZuordnungAdapter() {
		if (akteur_ZuordnungItemProvider == null) {
			akteur_ZuordnungItemProvider = new Akteur_ZuordnungItemProvider(this);
		}

		return akteur_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Ausgabe_Fachdaten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ausgabe_FachdatenItemProvider ausgabe_FachdatenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Ausgabe_Fachdaten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAusgabe_FachdatenAdapter() {
		if (ausgabe_FachdatenItemProvider == null) {
			ausgabe_FachdatenItemProvider = new Ausgabe_FachdatenItemProvider(this);
		}

		return ausgabe_FachdatenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bauabschnitt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bauabschnitt_TypeClassItemProvider bauabschnitt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bauabschnitt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBauabschnitt_TypeClassAdapter() {
		if (bauabschnitt_TypeClassItemProvider == null) {
			bauabschnitt_TypeClassItemProvider = new Bauabschnitt_TypeClassItemProvider(this);
		}

		return bauabschnitt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bauphase_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bauphase_TypeClassItemProvider bauphase_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bauphase_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBauphase_TypeClassAdapter() {
		if (bauphase_TypeClassItemProvider == null) {
			bauphase_TypeClassItemProvider = new Bauphase_TypeClassItemProvider(this);
		}

		return bauphase_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bauzustand_Kurzbezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bauzustand_Kurzbezeichnung_TypeClassItemProvider bauzustand_Kurzbezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bauzustand_Kurzbezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBauzustand_Kurzbezeichnung_TypeClassAdapter() {
		if (bauzustand_Kurzbezeichnung_TypeClassItemProvider == null) {
			bauzustand_Kurzbezeichnung_TypeClassItemProvider = new Bauzustand_Kurzbezeichnung_TypeClassItemProvider(this);
		}

		return bauzustand_Kurzbezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bauzustand_Langbezeichnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bauzustand_Langbezeichnung_TypeClassItemProvider bauzustand_Langbezeichnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bauzustand_Langbezeichnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBauzustand_Langbezeichnung_TypeClassAdapter() {
		if (bauzustand_Langbezeichnung_TypeClassItemProvider == null) {
			bauzustand_Langbezeichnung_TypeClassItemProvider = new Bauzustand_Langbezeichnung_TypeClassItemProvider(this);
		}

		return bauzustand_Langbezeichnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bemerkung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bemerkung_TypeClassItemProvider bemerkung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bemerkung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBemerkung_TypeClassAdapter() {
		if (bemerkung_TypeClassItemProvider == null) {
			bemerkung_TypeClassItemProvider = new Bemerkung_TypeClassItemProvider(this);
		}

		return bemerkung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Anlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Anlage_TypeClassItemProvider bezeichnung_Anlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Anlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Anlage_TypeClassAdapter() {
		if (bezeichnung_Anlage_TypeClassItemProvider == null) {
			bezeichnung_Anlage_TypeClassItemProvider = new Bezeichnung_Anlage_TypeClassItemProvider(this);
		}

		return bezeichnung_Anlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Planung_Gruppe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Planung_Gruppe_TypeClassItemProvider bezeichnung_Planung_Gruppe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Planung_Gruppe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Planung_Gruppe_TypeClassAdapter() {
		if (bezeichnung_Planung_Gruppe_TypeClassItemProvider == null) {
			bezeichnung_Planung_Gruppe_TypeClassItemProvider = new Bezeichnung_Planung_Gruppe_TypeClassItemProvider(this);
		}

		return bezeichnung_Planung_Gruppe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Planung_Projekt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Planung_Projekt_TypeClassItemProvider bezeichnung_Planung_Projekt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Planung_Projekt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Planung_Projekt_TypeClassAdapter() {
		if (bezeichnung_Planung_Projekt_TypeClassItemProvider == null) {
			bezeichnung_Planung_Projekt_TypeClassItemProvider = new Bezeichnung_Planung_Projekt_TypeClassItemProvider(this);
		}

		return bezeichnung_Planung_Projekt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Unteranlage_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Unteranlage_TypeClassItemProvider bezeichnung_Unteranlage_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Bezeichnung_Unteranlage_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Unteranlage_TypeClassAdapter() {
		if (bezeichnung_Unteranlage_TypeClassItemProvider == null) {
			bezeichnung_Unteranlage_TypeClassItemProvider = new Bezeichnung_Unteranlage_TypeClassItemProvider(this);
		}

		return bezeichnung_Unteranlage_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Container_AttributeGroupItemProvider container_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Container_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContainer_AttributeGroupAdapter() {
		if (container_AttributeGroupItemProvider == null) {
			container_AttributeGroupItemProvider = new Container_AttributeGroupItemProvider(this);
		}

		return container_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Einzel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Abschluss_Einzel_TypeClassItemProvider datum_Abschluss_Einzel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Einzel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Abschluss_Einzel_TypeClassAdapter() {
		if (datum_Abschluss_Einzel_TypeClassItemProvider == null) {
			datum_Abschluss_Einzel_TypeClassItemProvider = new Datum_Abschluss_Einzel_TypeClassItemProvider(this);
		}

		return datum_Abschluss_Einzel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Gruppe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Abschluss_Gruppe_TypeClassItemProvider datum_Abschluss_Gruppe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Gruppe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Abschluss_Gruppe_TypeClassAdapter() {
		if (datum_Abschluss_Gruppe_TypeClassItemProvider == null) {
			datum_Abschluss_Gruppe_TypeClassItemProvider = new Datum_Abschluss_Gruppe_TypeClassItemProvider(this);
		}

		return datum_Abschluss_Gruppe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Projekt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Abschluss_Projekt_TypeClassItemProvider datum_Abschluss_Projekt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Abschluss_Projekt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Abschluss_Projekt_TypeClassAdapter() {
		if (datum_Abschluss_Projekt_TypeClassItemProvider == null) {
			datum_Abschluss_Projekt_TypeClassItemProvider = new Datum_Abschluss_Projekt_TypeClassItemProvider(this);
		}

		return datum_Abschluss_Projekt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Regelwerksstand_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Regelwerksstand_TypeClassItemProvider datum_Regelwerksstand_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Regelwerksstand_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Regelwerksstand_TypeClassAdapter() {
		if (datum_Regelwerksstand_TypeClassItemProvider == null) {
			datum_Regelwerksstand_TypeClassItemProvider = new Datum_Regelwerksstand_TypeClassItemProvider(this);
		}

		return datum_Regelwerksstand_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_TypeClassItemProvider datum_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_TypeClassAdapter() {
		if (datum_TypeClassItemProvider == null) {
			datum_TypeClassItemProvider = new Datum_TypeClassItemProvider(this);
		}

		return datum_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Uebernahme_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Datum_Uebernahme_TypeClassItemProvider datum_Uebernahme_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Datum_Uebernahme_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDatum_Uebernahme_TypeClassAdapter() {
		if (datum_Uebernahme_TypeClassItemProvider == null) {
			datum_Uebernahme_TypeClassItemProvider = new Datum_Uebernahme_TypeClassItemProvider(this);
		}

		return datum_Uebernahme_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.DocumentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.DocumentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.E_Mail_Adresse_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected E_Mail_Adresse_TypeClassItemProvider e_Mail_Adresse_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.E_Mail_Adresse_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createE_Mail_Adresse_TypeClassAdapter() {
		if (e_Mail_Adresse_TypeClassItemProvider == null) {
			e_Mail_Adresse_TypeClassItemProvider = new E_Mail_Adresse_TypeClassItemProvider(this);
		}

		return e_Mail_Adresse_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Erzeugung_Zeitstempel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Erzeugung_Zeitstempel_TypeClassItemProvider erzeugung_Zeitstempel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Erzeugung_Zeitstempel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErzeugung_Zeitstempel_TypeClassAdapter() {
		if (erzeugung_Zeitstempel_TypeClassItemProvider == null) {
			erzeugung_Zeitstempel_TypeClassItemProvider = new Erzeugung_Zeitstempel_TypeClassItemProvider(this);
		}

		return erzeugung_Zeitstempel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Fachdaten_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fachdaten_AttributeGroupItemProvider fachdaten_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Fachdaten_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFachdaten_AttributeGroupAdapter() {
		if (fachdaten_AttributeGroupItemProvider == null) {
			fachdaten_AttributeGroupItemProvider = new Fachdaten_AttributeGroupItemProvider(this);
		}

		return fachdaten_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Fuehrende_Oertlichkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fuehrende_Oertlichkeit_TypeClassItemProvider fuehrende_Oertlichkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Fuehrende_Oertlichkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFuehrende_Oertlichkeit_TypeClassAdapter() {
		if (fuehrende_Oertlichkeit_TypeClassItemProvider == null) {
			fuehrende_Oertlichkeit_TypeClassItemProvider = new Fuehrende_Oertlichkeit_TypeClassItemProvider(this);
		}

		return fuehrende_Oertlichkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Ident_Rolle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ident_Rolle_TypeClassItemProvider ident_Rolle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Ident_Rolle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIdent_Rolle_TypeClassAdapter() {
		if (ident_Rolle_TypeClassItemProvider == null) {
			ident_Rolle_TypeClassItemProvider = new Ident_Rolle_TypeClassItemProvider(this);
		}

		return ident_Rolle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Index_Ausgabe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Index_Ausgabe_TypeClassItemProvider index_Ausgabe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Index_Ausgabe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIndex_Ausgabe_TypeClassAdapter() {
		if (index_Ausgabe_TypeClassItemProvider == null) {
			index_Ausgabe_TypeClassItemProvider = new Index_Ausgabe_TypeClassItemProvider(this);
		}

		return index_Ausgabe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Informativ_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Informativ_TypeClassItemProvider informativ_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Informativ_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInformativ_TypeClassAdapter() {
		if (informativ_TypeClassItemProvider == null) {
			informativ_TypeClassItemProvider = new Informativ_TypeClassItemProvider(this);
		}

		return informativ_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Koordinatensystem_BB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Koordinatensystem_BB_TypeClassItemProvider koordinatensystem_BB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Koordinatensystem_BB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKoordinatensystem_BB_TypeClassAdapter() {
		if (koordinatensystem_BB_TypeClassItemProvider == null) {
			koordinatensystem_BB_TypeClassItemProvider = new Koordinatensystem_BB_TypeClassItemProvider(this);
		}

		return koordinatensystem_BB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Koordinatensystem_PB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Koordinatensystem_PB_TypeClassItemProvider koordinatensystem_PB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Koordinatensystem_PB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKoordinatensystem_PB_TypeClassAdapter() {
		if (koordinatensystem_PB_TypeClassItemProvider == null) {
			koordinatensystem_PB_TypeClassItemProvider = new Koordinatensystem_PB_TypeClassItemProvider(this);
		}

		return koordinatensystem_PB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Laufende_Nummer_Ausgabe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Laufende_Nummer_Ausgabe_TypeClassItemProvider laufende_Nummer_Ausgabe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Laufende_Nummer_Ausgabe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLaufende_Nummer_Ausgabe_TypeClassAdapter() {
		if (laufende_Nummer_Ausgabe_TypeClassItemProvider == null) {
			laufende_Nummer_Ausgabe_TypeClassItemProvider = new Laufende_Nummer_Ausgabe_TypeClassItemProvider(this);
		}

		return laufende_Nummer_Ausgabe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Objekte_Planungsbereich_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LST_Objekte_Planungsbereich_AttributeGroupItemProvider lsT_Objekte_Planungsbereich_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Objekte_Planungsbereich_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLST_Objekte_Planungsbereich_AttributeGroupAdapter() {
		if (lsT_Objekte_Planungsbereich_AttributeGroupItemProvider == null) {
			lsT_Objekte_Planungsbereich_AttributeGroupItemProvider = new LST_Objekte_Planungsbereich_AttributeGroupItemProvider(this);
		}

		return lsT_Objekte_Planungsbereich_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Planung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LST_Planung_AttributeGroupItemProvider lsT_Planung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Planung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLST_Planung_AttributeGroupAdapter() {
		if (lsT_Planung_AttributeGroupItemProvider == null) {
			lsT_Planung_AttributeGroupItemProvider = new LST_Planung_AttributeGroupItemProvider(this);
		}

		return lsT_Planung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Zustand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LST_ZustandItemProvider lsT_ZustandItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.LST_Zustand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLST_ZustandAdapter() {
		if (lsT_ZustandItemProvider == null) {
			lsT_ZustandItemProvider = new LST_ZustandItemProvider(this);
		}

		return lsT_ZustandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_10_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Name_Akteur_10_TypeClassItemProvider name_Akteur_10_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_10_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createName_Akteur_10_TypeClassAdapter() {
		if (name_Akteur_10_TypeClassItemProvider == null) {
			name_Akteur_10_TypeClassItemProvider = new Name_Akteur_10_TypeClassItemProvider(this);
		}

		return name_Akteur_10_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_5_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Name_Akteur_5_TypeClassItemProvider name_Akteur_5_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_5_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createName_Akteur_5_TypeClassAdapter() {
		if (name_Akteur_5_TypeClassItemProvider == null) {
			name_Akteur_5_TypeClassItemProvider = new Name_Akteur_5_TypeClassItemProvider(this);
		}

		return name_Akteur_5_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Name_Akteur_TypeClassItemProvider name_Akteur_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Akteur_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createName_Akteur_TypeClassAdapter() {
		if (name_Akteur_TypeClassItemProvider == null) {
			name_Akteur_TypeClassItemProvider = new Name_Akteur_TypeClassItemProvider(this);
		}

		return name_Akteur_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Organisation_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Name_Organisation_TypeClassItemProvider name_Organisation_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Name_Organisation_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createName_Organisation_TypeClassAdapter() {
		if (name_Organisation_TypeClassItemProvider == null) {
			name_Organisation_TypeClassItemProvider = new Name_Organisation_TypeClassItemProvider(this);
		}

		return name_Organisation_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Objektmanagement_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Objektmanagement_AttributeGroupItemProvider objektmanagement_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Objektmanagement_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObjektmanagement_AttributeGroupAdapter() {
		if (objektmanagement_AttributeGroupItemProvider == null) {
			objektmanagement_AttributeGroupItemProvider = new Objektmanagement_AttributeGroupItemProvider(this);
		}

		return objektmanagement_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Organisation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrganisationItemProvider organisationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Organisation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrganisationAdapter() {
		if (organisationItemProvider == null) {
			organisationItemProvider = new OrganisationItemProvider(this);
		}

		return organisationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Organisationseinheit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Organisationseinheit_TypeClassItemProvider organisationseinheit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Organisationseinheit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrganisationseinheit_TypeClassAdapter() {
		if (organisationseinheit_TypeClassItemProvider == null) {
			organisationseinheit_TypeClassItemProvider = new Organisationseinheit_TypeClassItemProvider(this);
		}

		return organisationseinheit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlanPro_SchnittstelleItemProvider planPro_SchnittstelleItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanPro_SchnittstelleAdapter() {
		if (planPro_SchnittstelleItemProvider == null) {
			planPro_SchnittstelleItemProvider = new PlanPro_SchnittstelleItemProvider(this);
		}

		return planPro_SchnittstelleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlanPro_Schnittstelle_Allg_AttributeGroupItemProvider planPro_Schnittstelle_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanPro_Schnittstelle_Allg_AttributeGroupAdapter() {
		if (planPro_Schnittstelle_Allg_AttributeGroupItemProvider == null) {
			planPro_Schnittstelle_Allg_AttributeGroupItemProvider = new PlanPro_Schnittstelle_Allg_AttributeGroupItemProvider(this);
		}

		return planPro_Schnittstelle_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_XSD_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlanPro_XSD_Version_TypeClassItemProvider planPro_XSD_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.PlanPro_XSD_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanPro_XSD_Version_TypeClassAdapter() {
		if (planPro_XSD_Version_TypeClassItemProvider == null) {
			planPro_XSD_Version_TypeClassItemProvider = new PlanPro_XSD_Version_TypeClassItemProvider(this);
		}

		return planPro_XSD_Version_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_E_Allg_AttributeGroupItemProvider planung_E_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_E_Allg_AttributeGroupAdapter() {
		if (planung_E_Allg_AttributeGroupItemProvider == null) {
			planung_E_Allg_AttributeGroupItemProvider = new Planung_E_Allg_AttributeGroupItemProvider(this);
		}

		return planung_E_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_E_Art_TypeClassItemProvider planung_E_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_E_Art_TypeClassAdapter() {
		if (planung_E_Art_TypeClassItemProvider == null) {
			planung_E_Art_TypeClassItemProvider = new Planung_E_Art_TypeClassItemProvider(this);
		}

		return planung_E_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Ausgabe_Besonders_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_E_Ausgabe_Besonders_AttributeGroupItemProvider planung_E_Ausgabe_Besonders_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Ausgabe_Besonders_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_E_Ausgabe_Besonders_AttributeGroupAdapter() {
		if (planung_E_Ausgabe_Besonders_AttributeGroupItemProvider == null) {
			planung_E_Ausgabe_Besonders_AttributeGroupItemProvider = new Planung_E_Ausgabe_Besonders_AttributeGroupItemProvider(this);
		}

		return planung_E_Ausgabe_Besonders_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Handlung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_E_Handlung_AttributeGroupItemProvider planung_E_Handlung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_E_Handlung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_E_Handlung_AttributeGroupAdapter() {
		if (planung_E_Handlung_AttributeGroupItemProvider == null) {
			planung_E_Handlung_AttributeGroupItemProvider = new Planung_E_Handlung_AttributeGroupItemProvider(this);
		}

		return planung_E_Handlung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_EinzelItemProvider planung_EinzelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Einzel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_EinzelAdapter() {
		if (planung_EinzelItemProvider == null) {
			planung_EinzelItemProvider = new Planung_EinzelItemProvider(this);
		}

		return planung_EinzelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_G_Allg_AttributeGroupItemProvider planung_G_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_G_Allg_AttributeGroupAdapter() {
		if (planung_G_Allg_AttributeGroupItemProvider == null) {
			planung_G_Allg_AttributeGroupItemProvider = new Planung_G_Allg_AttributeGroupItemProvider(this);
		}

		return planung_G_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Art_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_G_Art_Besonders_TypeClassItemProvider planung_G_Art_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Art_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_G_Art_Besonders_TypeClassAdapter() {
		if (planung_G_Art_Besonders_TypeClassItemProvider == null) {
			planung_G_Art_Besonders_TypeClassItemProvider = new Planung_G_Art_Besonders_TypeClassItemProvider(this);
		}

		return planung_G_Art_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Fuehrende_Strecke_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_G_Fuehrende_Strecke_AttributeGroupItemProvider planung_G_Fuehrende_Strecke_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Fuehrende_Strecke_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_G_Fuehrende_Strecke_AttributeGroupAdapter() {
		if (planung_G_Fuehrende_Strecke_AttributeGroupItemProvider == null) {
			planung_G_Fuehrende_Strecke_AttributeGroupItemProvider = new Planung_G_Fuehrende_Strecke_AttributeGroupItemProvider(this);
		}

		return planung_G_Fuehrende_Strecke_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Schriftfeld_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_G_Schriftfeld_AttributeGroupItemProvider planung_G_Schriftfeld_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_G_Schriftfeld_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_G_Schriftfeld_AttributeGroupAdapter() {
		if (planung_G_Schriftfeld_AttributeGroupItemProvider == null) {
			planung_G_Schriftfeld_AttributeGroupItemProvider = new Planung_G_Schriftfeld_AttributeGroupItemProvider(this);
		}

		return planung_G_Schriftfeld_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_GruppeItemProvider planung_GruppeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Gruppe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_GruppeAdapter() {
		if (planung_GruppeItemProvider == null) {
			planung_GruppeItemProvider = new Planung_GruppeItemProvider(this);
		}

		return planung_GruppeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_P_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_P_Allg_AttributeGroupItemProvider planung_P_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_P_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_P_Allg_AttributeGroupAdapter() {
		if (planung_P_Allg_AttributeGroupItemProvider == null) {
			planung_P_Allg_AttributeGroupItemProvider = new Planung_P_Allg_AttributeGroupItemProvider(this);
		}

		return planung_P_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Phase_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_Phase_TypeClassItemProvider planung_Phase_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Phase_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_Phase_TypeClassAdapter() {
		if (planung_Phase_TypeClassItemProvider == null) {
			planung_Phase_TypeClassItemProvider = new Planung_Phase_TypeClassItemProvider(this);
		}

		return planung_Phase_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Projekt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Planung_ProjektItemProvider planung_ProjektItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Planung_Projekt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlanung_ProjektAdapter() {
		if (planung_ProjektItemProvider == null) {
			planung_ProjektItemProvider = new Planung_ProjektItemProvider(this);
		}

		return planung_ProjektItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Polygone_Betrachtungsbereich_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Polygone_Betrachtungsbereich_AttributeGroupItemProvider polygone_Betrachtungsbereich_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Polygone_Betrachtungsbereich_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPolygone_Betrachtungsbereich_AttributeGroupAdapter() {
		if (polygone_Betrachtungsbereich_AttributeGroupItemProvider == null) {
			polygone_Betrachtungsbereich_AttributeGroupItemProvider = new Polygone_Betrachtungsbereich_AttributeGroupItemProvider(this);
		}

		return polygone_Betrachtungsbereich_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Polygone_Planungsbereich_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Polygone_Planungsbereich_AttributeGroupItemProvider polygone_Planungsbereich_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Polygone_Planungsbereich_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPolygone_Planungsbereich_AttributeGroupAdapter() {
		if (polygone_Planungsbereich_AttributeGroupItemProvider == null) {
			polygone_Planungsbereich_AttributeGroupItemProvider = new Polygone_Planungsbereich_AttributeGroupItemProvider(this);
		}

		return polygone_Planungsbereich_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Polygonzug_Betrachtungsbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Polygonzug_Betrachtungsbereich_TypeClassItemProvider polygonzug_Betrachtungsbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Polygonzug_Betrachtungsbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPolygonzug_Betrachtungsbereich_TypeClassAdapter() {
		if (polygonzug_Betrachtungsbereich_TypeClassItemProvider == null) {
			polygonzug_Betrachtungsbereich_TypeClassItemProvider = new Polygonzug_Betrachtungsbereich_TypeClassItemProvider(this);
		}

		return polygonzug_Betrachtungsbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Polygonzug_Planungsbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Polygonzug_Planungsbereich_TypeClassItemProvider polygonzug_Planungsbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Polygonzug_Planungsbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPolygonzug_Planungsbereich_TypeClassAdapter() {
		if (polygonzug_Planungsbereich_TypeClassItemProvider == null) {
			polygonzug_Planungsbereich_TypeClassItemProvider = new Polygonzug_Planungsbereich_TypeClassItemProvider(this);
		}

		return polygonzug_Planungsbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Projekt_Nummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Projekt_Nummer_TypeClassItemProvider projekt_Nummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Projekt_Nummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjekt_Nummer_TypeClassAdapter() {
		if (projekt_Nummer_TypeClassItemProvider == null) {
			projekt_Nummer_TypeClassItemProvider = new Projekt_Nummer_TypeClassItemProvider(this);
		}

		return projekt_Nummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Referenz_Planung_Basis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Referenz_Planung_Basis_TypeClassItemProvider referenz_Planung_Basis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Referenz_Planung_Basis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenz_Planung_Basis_TypeClassAdapter() {
		if (referenz_Planung_Basis_TypeClassItemProvider == null) {
			referenz_Planung_Basis_TypeClassItemProvider = new Referenz_Planung_Basis_TypeClassItemProvider(this);
		}

		return referenz_Planung_Basis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Referenz_Vergleich_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Referenz_Vergleich_Besonders_TypeClassItemProvider referenz_Vergleich_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Referenz_Vergleich_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenz_Vergleich_Besonders_TypeClassAdapter() {
		if (referenz_Vergleich_Besonders_TypeClassItemProvider == null) {
			referenz_Vergleich_Besonders_TypeClassItemProvider = new Referenz_Vergleich_Besonders_TypeClassItemProvider(this);
		}

		return referenz_Vergleich_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Abschnitt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Abschnitt_TypeClassItemProvider strecke_Abschnitt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Abschnitt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Abschnitt_TypeClassAdapter() {
		if (strecke_Abschnitt_TypeClassItemProvider == null) {
			strecke_Abschnitt_TypeClassItemProvider = new Strecke_Abschnitt_TypeClassItemProvider(this);
		}

		return strecke_Abschnitt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Km_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Km_TypeClassItemProvider strecke_Km_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Km_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Km_TypeClassAdapter() {
		if (strecke_Km_TypeClassItemProvider == null) {
			strecke_Km_TypeClassItemProvider = new Strecke_Km_TypeClassItemProvider(this);
		}

		return strecke_Km_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Nummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Nummer_TypeClassItemProvider strecke_Nummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Strecke_Nummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Nummer_TypeClassAdapter() {
		if (strecke_Nummer_TypeClassItemProvider == null) {
			strecke_Nummer_TypeClassItemProvider = new Strecke_Nummer_TypeClassItemProvider(this);
		}

		return strecke_Nummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Telefonnummer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Telefonnummer_TypeClassItemProvider telefonnummer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Telefonnummer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTelefonnummer_TypeClassAdapter() {
		if (telefonnummer_TypeClassItemProvider == null) {
			telefonnummer_TypeClassItemProvider = new Telefonnummer_TypeClassItemProvider(this);
		}

		return telefonnummer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Untergewerk_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Untergewerk_Art_TypeClassItemProvider untergewerk_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Untergewerk_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUntergewerk_Art_TypeClassAdapter() {
		if (untergewerk_Art_TypeClassItemProvider == null) {
			untergewerk_Art_TypeClassItemProvider = new Untergewerk_Art_TypeClassItemProvider(this);
		}

		return untergewerk_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Verantwortliche_Stelle_DB_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Verantwortliche_Stelle_DB_TypeClassItemProvider verantwortliche_Stelle_DB_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Verantwortliche_Stelle_DB_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVerantwortliche_Stelle_DB_TypeClassAdapter() {
		if (verantwortliche_Stelle_DB_TypeClassItemProvider == null) {
			verantwortliche_Stelle_DB_TypeClassItemProvider = new Verantwortliche_Stelle_DB_TypeClassItemProvider(this);
		}

		return verantwortliche_Stelle_DB_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Vergleich_Ausgabestand_Basis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vergleich_Ausgabestand_Basis_TypeClassItemProvider vergleich_Ausgabestand_Basis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Vergleich_Ausgabestand_Basis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVergleich_Ausgabestand_Basis_TypeClassAdapter() {
		if (vergleich_Ausgabestand_Basis_TypeClassItemProvider == null) {
			vergleich_Ausgabestand_Basis_TypeClassItemProvider = new Vergleich_Ausgabestand_Basis_TypeClassItemProvider(this);
		}

		return vergleich_Ausgabestand_Basis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Vergleichstyp_Besonders_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vergleichstyp_Besonders_TypeClassItemProvider vergleichstyp_Besonders_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Vergleichstyp_Besonders_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVergleichstyp_Besonders_TypeClassAdapter() {
		if (vergleichstyp_Besonders_TypeClassItemProvider == null) {
			vergleichstyp_Besonders_TypeClassItemProvider = new Vergleichstyp_Besonders_TypeClassItemProvider(this);
		}

		return vergleichstyp_Besonders_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Werkzeug_Name_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Werkzeug_Name_TypeClassItemProvider werkzeug_Name_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Werkzeug_Name_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWerkzeug_Name_TypeClassAdapter() {
		if (werkzeug_Name_TypeClassItemProvider == null) {
			werkzeug_Name_TypeClassItemProvider = new Werkzeug_Name_TypeClassItemProvider(this);
		}

		return werkzeug_Name_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.PlanPro.Werkzeug_Version_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Werkzeug_Version_TypeClassItemProvider werkzeug_Version_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.PlanPro.Werkzeug_Version_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWerkzeug_Version_TypeClassAdapter() {
		if (werkzeug_Version_TypeClassItemProvider == null) {
			werkzeug_Version_TypeClassItemProvider = new Werkzeug_Version_TypeClassItemProvider(this);
		}

		return werkzeug_Version_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (adresse_PLZ_Ort_TypeClassItemProvider != null) adresse_PLZ_Ort_TypeClassItemProvider.dispose();
		if (adresse_Strasse_Nr_TypeClassItemProvider != null) adresse_Strasse_Nr_TypeClassItemProvider.dispose();
		if (akteurItemProvider != null) akteurItemProvider.dispose();
		if (akteur_Allg_AttributeGroupItemProvider != null) akteur_Allg_AttributeGroupItemProvider.dispose();
		if (akteur_ZuordnungItemProvider != null) akteur_ZuordnungItemProvider.dispose();
		if (ausgabe_FachdatenItemProvider != null) ausgabe_FachdatenItemProvider.dispose();
		if (bauabschnitt_TypeClassItemProvider != null) bauabschnitt_TypeClassItemProvider.dispose();
		if (bauphase_TypeClassItemProvider != null) bauphase_TypeClassItemProvider.dispose();
		if (bauzustand_Kurzbezeichnung_TypeClassItemProvider != null) bauzustand_Kurzbezeichnung_TypeClassItemProvider.dispose();
		if (bauzustand_Langbezeichnung_TypeClassItemProvider != null) bauzustand_Langbezeichnung_TypeClassItemProvider.dispose();
		if (bemerkung_TypeClassItemProvider != null) bemerkung_TypeClassItemProvider.dispose();
		if (bezeichnung_Anlage_TypeClassItemProvider != null) bezeichnung_Anlage_TypeClassItemProvider.dispose();
		if (bezeichnung_Planung_Gruppe_TypeClassItemProvider != null) bezeichnung_Planung_Gruppe_TypeClassItemProvider.dispose();
		if (bezeichnung_Planung_Projekt_TypeClassItemProvider != null) bezeichnung_Planung_Projekt_TypeClassItemProvider.dispose();
		if (bezeichnung_Unteranlage_TypeClassItemProvider != null) bezeichnung_Unteranlage_TypeClassItemProvider.dispose();
		if (container_AttributeGroupItemProvider != null) container_AttributeGroupItemProvider.dispose();
		if (datum_Abschluss_Einzel_TypeClassItemProvider != null) datum_Abschluss_Einzel_TypeClassItemProvider.dispose();
		if (datum_Abschluss_Gruppe_TypeClassItemProvider != null) datum_Abschluss_Gruppe_TypeClassItemProvider.dispose();
		if (datum_Abschluss_Projekt_TypeClassItemProvider != null) datum_Abschluss_Projekt_TypeClassItemProvider.dispose();
		if (datum_Regelwerksstand_TypeClassItemProvider != null) datum_Regelwerksstand_TypeClassItemProvider.dispose();
		if (datum_TypeClassItemProvider != null) datum_TypeClassItemProvider.dispose();
		if (datum_Uebernahme_TypeClassItemProvider != null) datum_Uebernahme_TypeClassItemProvider.dispose();
		if (documentRootItemProvider != null) documentRootItemProvider.dispose();
		if (e_Mail_Adresse_TypeClassItemProvider != null) e_Mail_Adresse_TypeClassItemProvider.dispose();
		if (erzeugung_Zeitstempel_TypeClassItemProvider != null) erzeugung_Zeitstempel_TypeClassItemProvider.dispose();
		if (fachdaten_AttributeGroupItemProvider != null) fachdaten_AttributeGroupItemProvider.dispose();
		if (fuehrende_Oertlichkeit_TypeClassItemProvider != null) fuehrende_Oertlichkeit_TypeClassItemProvider.dispose();
		if (ident_Rolle_TypeClassItemProvider != null) ident_Rolle_TypeClassItemProvider.dispose();
		if (index_Ausgabe_TypeClassItemProvider != null) index_Ausgabe_TypeClassItemProvider.dispose();
		if (informativ_TypeClassItemProvider != null) informativ_TypeClassItemProvider.dispose();
		if (koordinatensystem_BB_TypeClassItemProvider != null) koordinatensystem_BB_TypeClassItemProvider.dispose();
		if (koordinatensystem_PB_TypeClassItemProvider != null) koordinatensystem_PB_TypeClassItemProvider.dispose();
		if (laufende_Nummer_Ausgabe_TypeClassItemProvider != null) laufende_Nummer_Ausgabe_TypeClassItemProvider.dispose();
		if (lsT_Objekte_Planungsbereich_AttributeGroupItemProvider != null) lsT_Objekte_Planungsbereich_AttributeGroupItemProvider.dispose();
		if (lsT_Planung_AttributeGroupItemProvider != null) lsT_Planung_AttributeGroupItemProvider.dispose();
		if (lsT_ZustandItemProvider != null) lsT_ZustandItemProvider.dispose();
		if (name_Akteur_10_TypeClassItemProvider != null) name_Akteur_10_TypeClassItemProvider.dispose();
		if (name_Akteur_5_TypeClassItemProvider != null) name_Akteur_5_TypeClassItemProvider.dispose();
		if (name_Akteur_TypeClassItemProvider != null) name_Akteur_TypeClassItemProvider.dispose();
		if (name_Organisation_TypeClassItemProvider != null) name_Organisation_TypeClassItemProvider.dispose();
		if (objektmanagement_AttributeGroupItemProvider != null) objektmanagement_AttributeGroupItemProvider.dispose();
		if (organisationItemProvider != null) organisationItemProvider.dispose();
		if (organisationseinheit_TypeClassItemProvider != null) organisationseinheit_TypeClassItemProvider.dispose();
		if (planPro_SchnittstelleItemProvider != null) planPro_SchnittstelleItemProvider.dispose();
		if (planPro_Schnittstelle_Allg_AttributeGroupItemProvider != null) planPro_Schnittstelle_Allg_AttributeGroupItemProvider.dispose();
		if (planPro_XSD_Version_TypeClassItemProvider != null) planPro_XSD_Version_TypeClassItemProvider.dispose();
		if (planung_E_Allg_AttributeGroupItemProvider != null) planung_E_Allg_AttributeGroupItemProvider.dispose();
		if (planung_E_Art_TypeClassItemProvider != null) planung_E_Art_TypeClassItemProvider.dispose();
		if (planung_E_Ausgabe_Besonders_AttributeGroupItemProvider != null) planung_E_Ausgabe_Besonders_AttributeGroupItemProvider.dispose();
		if (planung_E_Handlung_AttributeGroupItemProvider != null) planung_E_Handlung_AttributeGroupItemProvider.dispose();
		if (planung_EinzelItemProvider != null) planung_EinzelItemProvider.dispose();
		if (planung_G_Allg_AttributeGroupItemProvider != null) planung_G_Allg_AttributeGroupItemProvider.dispose();
		if (planung_G_Art_Besonders_TypeClassItemProvider != null) planung_G_Art_Besonders_TypeClassItemProvider.dispose();
		if (planung_G_Fuehrende_Strecke_AttributeGroupItemProvider != null) planung_G_Fuehrende_Strecke_AttributeGroupItemProvider.dispose();
		if (planung_G_Schriftfeld_AttributeGroupItemProvider != null) planung_G_Schriftfeld_AttributeGroupItemProvider.dispose();
		if (planung_GruppeItemProvider != null) planung_GruppeItemProvider.dispose();
		if (planung_P_Allg_AttributeGroupItemProvider != null) planung_P_Allg_AttributeGroupItemProvider.dispose();
		if (planung_Phase_TypeClassItemProvider != null) planung_Phase_TypeClassItemProvider.dispose();
		if (planung_ProjektItemProvider != null) planung_ProjektItemProvider.dispose();
		if (polygone_Betrachtungsbereich_AttributeGroupItemProvider != null) polygone_Betrachtungsbereich_AttributeGroupItemProvider.dispose();
		if (polygone_Planungsbereich_AttributeGroupItemProvider != null) polygone_Planungsbereich_AttributeGroupItemProvider.dispose();
		if (polygonzug_Betrachtungsbereich_TypeClassItemProvider != null) polygonzug_Betrachtungsbereich_TypeClassItemProvider.dispose();
		if (polygonzug_Planungsbereich_TypeClassItemProvider != null) polygonzug_Planungsbereich_TypeClassItemProvider.dispose();
		if (projekt_Nummer_TypeClassItemProvider != null) projekt_Nummer_TypeClassItemProvider.dispose();
		if (referenz_Planung_Basis_TypeClassItemProvider != null) referenz_Planung_Basis_TypeClassItemProvider.dispose();
		if (referenz_Vergleich_Besonders_TypeClassItemProvider != null) referenz_Vergleich_Besonders_TypeClassItemProvider.dispose();
		if (strecke_Abschnitt_TypeClassItemProvider != null) strecke_Abschnitt_TypeClassItemProvider.dispose();
		if (strecke_Km_TypeClassItemProvider != null) strecke_Km_TypeClassItemProvider.dispose();
		if (strecke_Nummer_TypeClassItemProvider != null) strecke_Nummer_TypeClassItemProvider.dispose();
		if (telefonnummer_TypeClassItemProvider != null) telefonnummer_TypeClassItemProvider.dispose();
		if (untergewerk_Art_TypeClassItemProvider != null) untergewerk_Art_TypeClassItemProvider.dispose();
		if (verantwortliche_Stelle_DB_TypeClassItemProvider != null) verantwortliche_Stelle_DB_TypeClassItemProvider.dispose();
		if (vergleich_Ausgabestand_Basis_TypeClassItemProvider != null) vergleich_Ausgabestand_Basis_TypeClassItemProvider.dispose();
		if (vergleichstyp_Besonders_TypeClassItemProvider != null) vergleichstyp_Besonders_TypeClassItemProvider.dispose();
		if (werkzeug_Name_TypeClassItemProvider != null) werkzeug_Name_TypeClassItemProvider.dispose();
		if (werkzeug_Version_TypeClassItemProvider != null) werkzeug_Version_TypeClassItemProvider.dispose();
	}

}
