/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.FoldingStyle;

public class DEdgeQuery {
    private final DEdge edge;

    public DEdgeQuery(DEdge edge) {
        this.edge = (DEdge)Preconditions.checkNotNull((Object)edge);
    }

    public static Predicate<DEdge> hasFoldingStyle(final FoldingStyle style) {
        return new Predicate<DEdge>(){

            public boolean apply(DEdge input) {
                return new DEdgeQuery(input).getFoldingStyle() == style;
            }
        };
    }

    public FoldingStyle getFoldingStyle() {
        EdgeStyle style = this.edge.getOwnedStyle();
        if (style != null) {
            return style.getFoldingStyle();
        }
        return FoldingStyle.NONE_LITERAL;
    }

    public EdgeTarget getFoldingTarget() {
        if (this.getFoldingStyle() == FoldingStyle.SOURCE_LITERAL) {
            return this.edge.getTargetNode();
        }
        return this.edge.getSourceNode();
    }

    public Routing getRouting() {
        Routing routing = null;
        EdgeRouting newRoutingStyle = this.edge.getOwnedStyle().getRoutingStyle();
        routing = newRoutingStyle == EdgeRouting.MANHATTAN_LITERAL ? Routing.RECTILINEAR_LITERAL : (newRoutingStyle == EdgeRouting.TREE_LITERAL ? Routing.TREE_LITERAL : Routing.MANUAL_LITERAL);
        return routing;
    }

    public Optional<DDiagram> getDDiagram() {
        return this.getDDiagram(this.edge.eContainer());
    }

    private Optional<DDiagram> getDDiagram(EObject object) {
        Optional<DDiagram> result = Optional.empty();
        if (object instanceof DDiagram) {
            result = Optional.of((DDiagram)object);
        } else if (object != null) {
            result = this.getDDiagram(object.eContainer());
        }
        return result;
    }
}

