/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.ecore;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.common.tools.Messages;

public class DynamicEPackageService {

    static class EPackageDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements EPackage.Descriptor {
        public EPackageDescriptor(IConfigurationElement element, String attributeName) {
            super(element, attributeName);
        }

        public EPackage getEPackage() {
            try {
                Class javaClass = Platform.getBundle((String)this.element.getDeclaringExtension().getContributor().getName()).loadClass(this.element.getAttribute(this.attributeName));
                Field field = javaClass.getField("eINSTANCE");
                Object result = field.get(null);
                return (EPackage)result;
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedException((Exception)e);
            }
            catch (NoSuchFieldException e) {
                throw new WrappedException((Exception)e);
            }
        }

        public EFactory getEFactory() {
            return null;
        }

        static class Dynamic
        extends EPackageDescriptor {
            protected static ResourceSet resourceSet = new ResourceSetImpl(){
                protected Set<URI> uris = new HashSet<URI>();

                protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                    try {
                        Resource resource = this.uris.add(uri) ? super.delegatedGetResource(uri, loadOnDemand) : null;
                        return resource;
                    }
                    finally {
                        this.uris.remove(uri);
                    }
                }
            };

            public Dynamic(IConfigurationElement element, String attributeName) {
                super(element, attributeName);
            }

            @Override
            public EPackage getEPackage() {
                try {
                    String location = this.element.getAttribute(this.attributeName);
                    if (location != null) {
                        URI locationURI = URI.createURI((String)location);
                        if (locationURI.isRelative()) {
                            locationURI = URI.createPlatformPluginURI((String)(String.valueOf(this.element.getDeclaringExtension().getContributor().getName()) + "/" + location), (boolean)true);
                        }
                        if (!locationURI.hasFragment()) {
                            locationURI = locationURI.appendFragment("/");
                        }
                        return (EPackage)resourceSet.getEObject(locationURI, true);
                    }
                    throw new RuntimeException(Messages.DynamicEPackageService_missingLocationAttribute);
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
        }
    }
}

