/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.mutation;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.ContainerPathArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.NameArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.ProjectNameArgument;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.WorkspaceOptionalUtils;

public final class CreateFolderField {
    private static final String CREATE_FOLDER_FIELD = "createFolder";

    private CreateFolderField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(CREATE_FOLDER_FIELD).argument(ProjectNameArgument.build()).argument(ContainerPathArgument.build()).argument(NameArgument.build()).type((GraphQLOutputType)new GraphQLTypeReference("Folder")).dataFetcher(CreateFolderField.getCreateFolderDataFetcher()).build();
    }

    private static DataFetcher<IFolder> getCreateFolderDataFetcher() {
        return environment -> {
            Optional<IProject> optionalProject = WorkspaceOptionalUtils.projectFromName(environment.getArgument("projectName"));
            Optional<String> optionalContainerPath = Optional.of((String)environment.getArgument("containerPath"));
            Optional<String> optionalName = Optional.of((String)environment.getArgument("name"));
            if (optionalProject.isPresent() && optionalContainerPath.isPresent() && optionalName.isPresent()) {
                String name;
                IContainer iContainer;
                IFolder iFolder;
                String containerPath = optionalContainerPath.get();
                Optional<IContainer> optionalContainer = optionalProject.map(iProject -> iProject.findMember(containerPath)).filter(IContainer.class::isInstance).map(IContainer.class::cast);
                if (optionalContainer.isPresent() && !(iFolder = (iContainer = optionalContainer.get()).getFolder((IPath)new Path(name = optionalName.get()))).exists()) {
                    try {
                        iFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException exception) {
                        Status status = new Status(4, "org.eclipse.sirius.services.graphql", exception.getMessage(), (Throwable)exception);
                        SiriusGraphQLPlugin.getPlugin().log(status);
                    }
                    return iFolder;
                }
            }
            return null;
        };
    }
}

