/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.api;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.services.diagram.api.AbstractSiriusDiagramAction;
import org.eclipse.sirius.services.diagram.api.SiriusDiagramMessage;
import org.eclipse.sirius.services.diagram.internal.SiriusDiagramPrecommitListener;
import org.eclipse.sirius.services.diagram.internal.SiriusDiagramResourceSetListener;
import org.eclipse.sirius.services.diagram.internal.actions.SiriusDiagramActionHandlerSwitch;

public class SiriusDiagramService {
    private Session session;
    private DDiagram dDiagram;
    private Consumer<SiriusDiagramMessage> callback;
    private SiriusDiagramPrecommitListener precommitListener;
    private SiriusDiagramResourceSetListener resourceSetListener;

    public SiriusDiagramService(Session session, DDiagram dDiagram, Consumer<SiriusDiagramMessage> callback) {
        this.session = session;
        this.dDiagram = dDiagram;
        this.callback = callback;
        this.precommitListener = new SiriusDiagramPrecommitListener(this.dDiagram);
        this.resourceSetListener = new SiriusDiagramResourceSetListener(this);
    }

    public void initialize() {
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.precommitListener);
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this.resourceSetListener);
    }

    public void accept(SiriusDiagramMessage message) {
        AbstractSiriusDiagramAction action = message.getAction();
        Optional optionalActionHandler = (Optional)new SiriusDiagramActionHandlerSwitch().doSwitch(action);
        optionalActionHandler.filter(handler -> handler.canHandle(this, action)).ifPresent(handler -> handler.handle(this, action));
    }

    public void dispatch(SiriusDiagramMessage message) {
        this.callback.accept(message);
    }

    public void dispose() {
        this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.precommitListener);
        this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this.resourceSetListener);
    }

    public Session getSession() {
        return this.session;
    }

    public DDiagram getDDiagram() {
        return this.dDiagram;
    }
}

