/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.core.internal.schema;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypesProvider;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnectionTypeProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLEdgeTypeProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointTypesBuilder
implements ISiriusGraphQLTypesProvider {
    private static final String IDENTIFIER_FIELD = "identifier";
    private static final String NAME_FIELD = "name";
    private static final String REPRESENTATION_DESCRIPTIONS_FIELD = "representationDescriptions";
    private static final int COMPLEXITY = 1;

    public Set<GraphQLType> getTypes(ISiriusGraphQLTypeCustomizer customizer) {
        GraphQLObjectType representationDescriptionEdge = new SiriusGraphQLEdgeTypeProvider("ViewpointRepresentationDescriptionEdge", "RepresentationDescription").getType(customizer);
        GraphQLObjectType representationDescriptionConnection = new SiriusGraphQLConnectionTypeProvider("ViewpointRepresentationDescriptionConnection", "ViewpointRepresentationDescriptionEdge").getType(customizer);
        GraphQLObjectType.Builder viewpointBuilder = GraphQLObjectType.newObject().name("Viewpoint").field(this.getIdentifierField()).field(this.getNameField()).field(this.getRepresentationDescriptionsField());
        GraphQLObjectType.Builder customizedViewpointBuilder = customizer.customize("Viewpoint", viewpointBuilder);
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add((GraphQLType)customizedViewpointBuilder.build());
        types.add((GraphQLType)representationDescriptionEdge);
        types.add((GraphQLType)representationDescriptionConnection);
        return types;
    }

    private GraphQLFieldDefinition getIdentifierField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(IDENTIFIER_FIELD).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(this.getIdentifierDataFetcher()).build();
    }

    private DataFetcher<String> getIdentifierDataFetcher() {
        return environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(IdentifiedElement::getName).orElse(null);
    }

    private GraphQLFieldDefinition getNameField() {
        return GraphQLFieldDefinition.newFieldDefinition().name(NAME_FIELD).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).dataFetcher(this.getNameDataFetcher()).build();
    }

    private DataFetcher<String> getNameDataFetcher() {
        return environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(IdentifiedElementQuery::new).map(IdentifiedElementQuery::getLabel).orElse(null);
    }

    private GraphQLFieldDefinition getRepresentationDescriptionsField() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(REPRESENTATION_DESCRIPTIONS_FIELD).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).type((GraphQLOutputType)new GraphQLTypeReference("ViewpointRepresentationDescriptionConnection")).dataFetcher(this.getRepresentationDescriptionsDataFetcher()).build();
    }

    private DataFetcher<SiriusGraphQLConnection> getRepresentationDescriptionsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> Optional.of(environment.getSource()).filter(Viewpoint.class::isInstance).map(Viewpoint.class::cast).map(viewpoint -> viewpoint.getOwnedRepresentations().stream().filter(DiagramDescription.class::isInstance).collect(Collectors.toList())).orElseGet(ArrayList::new), this::diagramDescriptionCursorComputer);
    }

    private String diagramDescriptionCursorComputer(RepresentationDescription representationDescription) {
        String unEncodedCursor = EcoreUtil.getURI((EObject)representationDescription).toString();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

