/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.editor;

import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;

public class UndoRedoActionHandler
extends Action {
    private IUndoContext undoContext;
    private RedoActionHandler redoActionHandler;
    private UndoActionHandler undoActionHandler;
    private IEditorSite site;
    private TransactionalEditingDomain domain;

    public UndoRedoActionHandler(TransactionalEditingDomain domain, IEditorSite editorSite) {
        this.domain = domain;
        this.site = editorSite;
        this.initializeUndoRedoActionHandlers();
    }

    private void initializeUndoRedoActionHandlers() {
        IUndoContext editorUndoContext = this.getUndoContext();
        if (editorUndoContext != null) {
            this.undoActionHandler = new UndoActionHandler((IWorkbenchPartSite)this.site, editorUndoContext);
            this.site.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoActionHandler);
            this.redoActionHandler = new RedoActionHandler((IWorkbenchPartSite)this.site, editorUndoContext);
            this.site.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoActionHandler);
        }
    }

    protected IUndoContext getUndoContext() {
        if (this.undoContext == null && this.domain != null && this.domain.getCommandStack() instanceof IWorkspaceCommandStack) {
            this.undoContext = ((IWorkspaceCommandStack)this.domain.getCommandStack()).getDefaultUndoContext();
        }
        return this.undoContext;
    }

    public void dispose() {
        if (this.redoActionHandler != null) {
            this.redoActionHandler.dispose();
        }
        if (this.undoActionHandler != null) {
            this.undoActionHandler.dispose();
        }
    }
}

