/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.junit.Assert;

public abstract class AbstractColorReferenceTestCase
extends TestCase {
    private Collection<EReference> colorReferences;
    private Collection<EClass> classesWithColorReferences;
    private Collection<EReference> specialColorRefs = new ArrayList<EReference>();
    private EPackage basePackage;
    private final Predicate<EReference> isColorReference = new Predicate<EReference>(){

        public boolean apply(EReference input) {
            return !input.isContainment() && org.eclipse.sirius.viewpoint.description.DescriptionPackage.eINSTANCE.getColorDescription().isSuperTypeOf(input.getEReferenceType());
        }
    };

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.colorReferences = new LinkedHashSet<EReference>();
        this.classesWithColorReferences = new LinkedHashSet<EClass>();
        Assert.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
        this.lookForColorReferences(this.basePackage);
        this.specialColorRefs = Arrays.asList(DescriptionPackage.eINSTANCE.getDiagramDescription_BackgroundColor());
    }

    private void lookForColorReferences(EPackage pkg) {
        for (EClass eclass : Iterables.filter((Iterable)pkg.getEClassifiers(), EClass.class)) {
            this.lookForColorReferences(eclass);
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.lookForColorReferences(subPkg);
        }
    }

    private void lookForColorReferences(EClass eclass) {
        Iterable allColorReferences = Iterables.filter((Iterable)eclass.getEAllReferences(), this.isColorReference);
        Iterables.addAll(this.colorReferences, (Iterable)allColorReferences);
        if (!(Iterables.isEmpty((Iterable)allColorReferences) || eclass.isAbstract() || eclass.isInterface())) {
            this.classesWithColorReferences.add(eclass);
        }
    }

    public void testColorReferencesCardinality() {
        ArrayList<EReference> referencesWithWrongCardinality = new ArrayList<EReference>();
        Predicate<EReference> shouldBeRequired = new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return !input.isRequired() && !AbstractColorReferenceTestCase.this.specialColorRefs.contains(input);
            }
        };
        Iterables.addAll(referencesWithWrongCardinality, (Iterable)Iterables.filter(this.colorReferences, (Predicate)shouldBeRequired));
        Assert.assertTrue((String)this.getMessage(referencesWithWrongCardinality), (boolean)referencesWithWrongCardinality.isEmpty());
    }

    public void testColorReferencesInitialization() {
        StringBuilder sb = new StringBuilder();
        for (EClass clazz : this.classesWithColorReferences) {
            EObject created = EcoreUtil.create((EClass)clazz);
            for (EReference colorRef : Iterables.filter((Iterable)clazz.getEAllReferences(), this.isColorReference)) {
                if (created.eIsSet((EStructuralFeature)colorRef) && created.eGet((EStructuralFeature)colorRef) != null || this.specialColorRefs.contains(colorRef)) continue;
                sb.append(" . " + clazz.getName() + "#" + colorRef.getName() + "\n");
            }
        }
        TestCase.assertTrue((String)("Some color references need initialization:\n" + sb.toString()), (sb.length() == 0 ? 1 : 0) != 0);
    }

    private String getMessage(List<EReference> referencesWithWrongCardinality) {
        StringBuilder sb = new StringBuilder();
        sb.append(referencesWithWrongCardinality.size());
        sb.append(" color references should be required, please modify their cardinality:");
        for (EReference ref : referencesWithWrongCardinality) {
            sb.append("\n . ");
            sb.append(ref.eResource().getURIFragment((EObject)ref));
        }
        return sb.toString();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.basePackage = null;
        this.colorReferences.clear();
        this.classesWithColorReferences.clear();
    }
}

