/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderer;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingConfigurator;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class DisCoGraphRenderingCanvas
extends Canvas
implements PaintListener {
    private ElkNode layoutGraph;
    private DisCoGraphRenderer graphRenderer;
    private Color backgroundColor;

    public DisCoGraphRenderingCanvas(Composite parent) {
        super(parent, 0);
        this.addPaintListener(this);
        this.graphRenderer = new DisCoGraphRenderer(new DisCoGraphRenderingConfigurator(parent.getDisplay()));
        this.backgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.setBackground(this.backgroundColor);
    }

    public DisCoGraphRenderingCanvas(Composite parent, DisCoGraphRenderingConfigurator configurator) {
        super(parent, 0);
        if (!configurator.getDisplay().equals(parent.getDisplay())) {
            throw new IllegalArgumentException("configurator and parent composite must use the same display.");
        }
        this.addPaintListener(this);
        this.graphRenderer = new DisCoGraphRenderer(configurator);
        this.backgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.setBackground(this.backgroundColor);
    }

    public void dispose() {
        this.graphRenderer.dispose();
        this.backgroundColor.dispose();
    }

    public void setLayoutGraph(ElkNode thelayoutGraph) {
        if (thelayoutGraph != null) {
            this.setSize(new Point((int)((thelayoutGraph.getWidth() + 1.0) * this.graphRenderer.getScale()), (int)((thelayoutGraph.getHeight() + 1.0) * this.graphRenderer.getScale())));
        }
        this.layoutGraph = thelayoutGraph;
        this.redraw();
    }

    public ElkNode getLayoutGraph() {
        return this.layoutGraph;
    }

    public DisCoGraphRenderer getRenderer() {
        return this.graphRenderer;
    }

    public void paintControl(PaintEvent event) {
        if (this.layoutGraph != null) {
            Rectangle area = new Rectangle(event.x, event.y, event.width, event.height);
            this.graphRenderer.markDirty(area);
            this.graphRenderer.render(this.layoutGraph, event.gc, area);
        }
    }
}

