/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbsoluteBoundsFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;

public class SequenceRefreshExtension
implements IRefreshExtension {
    private SequenceDDiagram currentDiagram;
    private Map<EObject, AbsoluteBoundsFilter> flags;

    public void beforeRefresh(DDiagram dDiagram) {
        if (dDiagram instanceof SequenceDDiagram) {
            this.currentDiagram = (SequenceDDiagram)dDiagram;
            Collection<DDiagramElement> nodeEvents = this.getEventsToSync(this.currentDiagram);
            if (nodeEvents.size() != 0) {
                this.flags = Maps.newHashMapWithExpectedSize((int)nodeEvents.size());
                for (DDiagramElement elt : nodeEvents) {
                    Iterable flag = Iterables.filter((Iterable)elt.getGraphicalFilters(), AbsoluteBoundsFilter.class);
                    EObject semanticTarget = elt.getTarget();
                    if (semanticTarget == null || Iterables.size((Iterable)flag) != 1) continue;
                    this.flags.put(semanticTarget, (AbsoluteBoundsFilter)Iterables.getOnlyElement((Iterable)flag));
                }
            }
        }
    }

    public void postRefresh(DDiagram dDiagram) {
        Collection<DDiagramElement> nodeEvents;
        if (this.currentDiagram != null && this.currentDiagram.equals(dDiagram) && this.flags != null && (nodeEvents = this.getEventsToSync((SequenceDDiagram)dDiagram)).size() != 0) {
            for (DDiagramElement elt : nodeEvents) {
                Iterable flag = Iterables.filter((Iterable)elt.getGraphicalFilters(), AbsoluteBoundsFilter.class);
                EObject semanticTarget = elt.getTarget();
                if (semanticTarget == null || !Iterables.isEmpty((Iterable)flag) || !this.flags.containsKey(semanticTarget)) continue;
                AbsoluteBoundsFilter prevFlag = this.flags.get(semanticTarget);
                AbsoluteBoundsFilter newFlag = DiagramFactory.eINSTANCE.createAbsoluteBoundsFilter();
                newFlag.setX(Integer.valueOf(LayoutConstants.EXTERNAL_CHANGE_FLAG.x));
                newFlag.setY(prevFlag.getY());
                newFlag.setHeight(prevFlag.getHeight());
                newFlag.setWidth(prevFlag.getWidth());
                elt.getGraphicalFilters().add((Object)newFlag);
            }
        }
        if (this.flags != null) {
            this.flags.clear();
            this.flags = null;
        }
        this.currentDiagram = null;
    }

    private Collection<DDiagramElement> getEventsToSync(SequenceDDiagram sdd) {
        ArrayList diagramElements = Lists.newArrayList((Iterable)sdd.getDiagramElements());
        Predicate eventsToSync = Predicates.or(AbstractNodeEvent.viewpointElementPredicate(), Message.viewpointElementPredicate());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)diagramElements, (Predicate)eventsToSync));
    }
}

