/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.eclipse.sirius.tests.swtbot.support.internal.DesignerSWTBotTestsSupportPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.eclipse.gef.finder.SWTBotGefTestCase;
import org.eclipse.swtbot.swt.finder.SWTBotTestCase;
import org.eclipse.swtbot.swt.finder.utils.ClassUtils;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;

public final class SWTBotSplitEditor
extends SWTBotGefTestCase {
    private static boolean editorSplit = true;
    private static int screenshotCounter;
    private static Logger log;

    static {
        log = Logger.getLogger(SWTBotTestCase.class);
    }

    private SWTBotSplitEditor() {
    }

    public static void splitEditorArea() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SWTBotSplitEditor.doSplitEditorArea();
            }
        });
    }

    private static void doSplitEditorArea() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = workbenchPage.getActivePart();
        try {
            PartSite partSite = (PartSite)part.getSite();
            Method getPane = partSite.getClass().getMethod("getPane", new Class[0]);
            PartPane partPane = (PartPane)getPane.invoke((Object)partSite, new Object[0]);
            Class layoutPartClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.LayoutPart");
            IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
            Method getPart = layoutPartClass.getMethod("getPart", new Class[0]);
            Object layoutPart = getPart.invoke((Object)partPane, new Object[0]);
            if (editorReferences.length > 1) {
                Object editorSashLayoutContainer;
                getPane = ((PartSite)workbenchPage.getActiveEditor().getSite()).getClass().getMethod("getPane", new Class[0]);
                PartPane currentEditorPartPane = (PartPane)getPane.invoke((Object)workbenchPage.getActiveEditor().getSite(), new Object[0]);
                Object editorSashContainer = null;
                Class editorSashContainerClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.EditorSashContainer");
                Class iLayoutContainerClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.ILayoutContainer");
                Method getContainer = layoutPart.getClass().getMethod("getContainer", new Class[0]);
                Object rootLayoutContainer = getContainer.invoke(layoutPart, new Object[0]);
                if (layoutPartClass.isInstance(rootLayoutContainer) && editorSashContainerClass.isInstance(editorSashLayoutContainer = getContainer.invoke(layoutPartClass.cast(rootLayoutContainer), new Object[0]))) {
                    editorSashContainer = editorSashContainerClass.cast(editorSashLayoutContainer);
                }
                Class partStackClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.PartStack");
                Object newPart = SWTBotSplitEditor.createStack(editorSashContainer);
                if (newPart != null) {
                    partStackClass.cast(newPart);
                    Class[] paramTypes = new Class[]{layoutPartClass, iLayoutContainerClass};
                    Method stack = editorSashContainerClass.getMethod("stack", paramTypes);
                    stack.invoke(editorSashContainer, currentEditorPartPane, newPart);
                    if (layoutPartClass.isInstance(rootLayoutContainer)) {
                        Object cont = getContainer.invoke(layoutPartClass.cast(rootLayoutContainer), new Object[0]);
                        Class partSashContainerClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.PartSashContainer");
                        if (partSashContainerClass.isInstance(cont)) {
                            partSashContainerClass.cast(cont);
                            paramTypes = new Class[]{layoutPartClass};
                            Method add = partSashContainerClass.getMethod("add", paramTypes);
                            add.invoke(cont, newPart);
                        }
                    }
                } else {
                    SWTBotSplitEditor.setEditor_split(false);
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            SWTBotSplitEditor.setEditor_split(false);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SWTBotSplitEditor.setEditor_split(false);
        }
        catch (InvocationTargetException invocationTargetException) {
            SWTBotSplitEditor.setEditor_split(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SWTBotSplitEditor.setEditor_split(false);
        }
    }

    public static Object createStack(Object editorSashContainer) {
        WorkbenchPage workbenchPage = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        Object newWorkbook = null;
        try {
            Class editorStackClass = DesignerSWTBotTestsSupportPlugin.getDefault().getBundle().loadClass("org.eclipse.ui.internal.EditorStack");
            Class[] paramTypes = new Class[]{editorSashContainer.getClass(), workbenchPage.getClass()};
            Method newEditorWorkbook = editorStackClass.getMethod("newEditorWorkbook", paramTypes);
            newWorkbook = newEditorWorkbook.invoke(null, editorSashContainer, workbenchPage);
        }
        catch (IllegalAccessException illegalAccessException) {
            return newWorkbook;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return newWorkbook;
        }
        catch (InvocationTargetException invocationTargetException) {
            return newWorkbook;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return newWorkbook;
        }
        return newWorkbook;
    }

    public static boolean isEditor_split() {
        return editorSplit;
    }

    public static void setEditor_split(boolean editor_split) {
        editorSplit = editor_split;
    }

    public void runBare() throws Throwable {
        Throwable exception = null;
        try {
            super.runBare();
        }
        catch (Throwable running) {
            exception = running;
            this.captureScreenshot();
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void captureScreenshot() {
        try {
            int maximumScreenshots = SWTBotPreferences.MAX_ERROR_SCREENSHOT_COUNT;
            String fileName = SWTBotPreferences.SCREENSHOTS_DIR + "/screenshot-" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + "." + this.getName() + "." + SWTBotPreferences.SCREENSHOT_FORMAT.toLowerCase();
            if (++screenshotCounter <= maximumScreenshots) {
                new File(SWTBotPreferences.SCREENSHOTS_DIR).mkdirs();
                SWTUtils.captureScreenshot((String)fileName);
            } else {
                log.info((Object)("No screenshot captured for '" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + "." + this.getName() + "' because maximum number of screenshots reached: " + maximumScreenshots));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Could not capture screenshot", (Throwable)e);
        }
    }
}

