/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.internal.preference.DynamicConfigurationHelper;
import org.eclipse.sirius.tree.provider.TreeItemProviderAdapterFactory;
import org.eclipse.sirius.tree.ui.tools.api.preferences.SiriusTreeUiPreferencesKeys;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class TreeUIPlugin
extends EMFPlugin {
    public static final TreeUIPlugin INSTANCE = new TreeUIPlugin();
    private static Implementation plugin;
    public static final String ID = "org.eclipse.sirius.tree.ui";
    private static Map<ImageDescriptor, Image> descriptorsToImages;

    static {
        descriptorsToImages = new HashMap<ImageDescriptor, Image>();
    }

    public TreeUIPlugin() {
        super(new ResourceLocator[]{EcoreEditPlugin.INSTANCE, SiriusEditPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static Image getImage(ImageDescriptor desc) {
        if (!descriptorsToImages.containsKey(desc)) {
            descriptorsToImages.put(desc, desc.createImage());
        }
        return descriptorsToImages.get(desc);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile candidateImage = root.getFile((IPath)p);
        if (candidateImage.exists()) {
            try {
                URL url = new URL("platform:/resource" + p.makeAbsolute().toString());
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return TreeUIPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private ComposedAdapterFactory adapterFactory;
        private Configuration preferencesConfiguration;

        public Implementation() {
            plugin = this;
            this.preferencesConfiguration = new Configuration(this.getPreferenceStore());
        }

        public AdapterFactory getItemProvidersAdapterFactory() {
            if (this.adapterFactory == null) {
                this.adapterFactory = this.createAdapterFactory();
            }
            return this.adapterFactory;
        }

        public ComposedAdapterFactory createAdapterFactory() {
            ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
            factories.add((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            this.fillItemProviderFactories(factories);
            return new ComposedAdapterFactory(factories);
        }

        protected void fillItemProviderFactories(List<AdapterFactory> factories) {
            factories.add((AdapterFactory)new ViewpointItemProviderAdapterFactory());
            factories.add((AdapterFactory)new DescriptionItemProviderAdapterFactory());
            factories.add((AdapterFactory)new ToolItemProviderAdapterFactory());
            factories.add((AdapterFactory)new AuditItemProviderAdapterFactory());
            factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
            factories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
            factories.add((AdapterFactory)new org.eclipse.sirius.tree.description.provider.DescriptionItemProviderAdapterFactory());
            factories.add((AdapterFactory)new TreeItemProviderAdapterFactory());
            factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }

        public void error(String message, Exception e) {
            if (message == null && e != null) {
                message = e.getMessage();
            }
            if (e instanceof CoreException) {
                this.getLog().log(((CoreException)e).getStatus());
            } else {
                Status status = new Status(4, this.getBundle().getSymbolicName(), message, (Throwable)e);
                this.getLog().log((IStatus)status);
            }
        }

        public boolean useStandardFont() {
            return this.preferencesConfiguration.useStandardFont;
        }

        private static class Configuration
        extends DynamicConfigurationHelper {
            boolean useStandardFont;

            Configuration(IPreferenceStore store) {
                super(store);
                this.bindBoolean(SiriusTreeUiPreferencesKeys.PREF_ALWAYS_USE_STANDARD_FONT_SIZE.name(), "useStandardFont");
            }
        }
    }
}

