/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.elk.alg.layered.DebugUtil;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeCycleDetector;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentSplitter;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.BaseRoutingDirectionStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.direction.RoutingDirection;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class OrthogonalRoutingGenerator {
    public static final double TOLERANCE = 0.001;
    private static final int CRITICAL_CONFLICTS_DETECTED = -1;
    private static final double CONFLICT_THRESHOLD_FACTOR = 0.5;
    private static final double CRITICAL_CONFLICT_THRESHOLD_FACTOR = 0.2;
    private static final int CONFLICT_PENALTY = 1;
    private static final int CROSSING_PENALTY = 16;
    private HyperEdgeSegmentSplitter segmentSplitter;
    private final BaseRoutingDirectionStrategy routingStrategy;
    private final double edgeSpacing;
    private final double conflictThreshold;
    private double criticalConflictThreshold;
    private final String debugPrefix;

    public OrthogonalRoutingGenerator(RoutingDirection direction, double edgeSpacing, String debugPrefix) {
        this.routingStrategy = BaseRoutingDirectionStrategy.forRoutingDirection(direction);
        this.edgeSpacing = edgeSpacing;
        this.conflictThreshold = 0.5 * edgeSpacing;
        this.debugPrefix = debugPrefix;
    }

    public int routeEdges(IElkProgressMonitor monitor, LGraph layeredGraph, Iterable<LNode> sourceLayerNodes, int sourceLayerIndex, Iterable<LNode> targetLayerNodes, double startPos) {
        HashMap portToEdgeSegmentMap = Maps.newHashMap();
        ArrayList edgeSegments = Lists.newArrayList();
        this.createHyperEdgeSegments(sourceLayerNodes, this.routingStrategy.getSourcePortSide(), edgeSegments, portToEdgeSegmentMap);
        this.createHyperEdgeSegments(targetLayerNodes, this.routingStrategy.getTargetPortSide(), edgeSegments, portToEdgeSegmentMap);
        this.criticalConflictThreshold = 0.2 * this.minimumHorizontalSegmentDistance(edgeSegments);
        int criticalDependencyCount = 0;
        int firstIdx = 0;
        while (firstIdx < edgeSegments.size() - 1) {
            HyperEdgeSegment firstSegment = (HyperEdgeSegment)edgeSegments.get(firstIdx);
            int secondIdx = firstIdx + 1;
            while (secondIdx < edgeSegments.size()) {
                criticalDependencyCount += this.createDependencyIfNecessary(firstSegment, (HyperEdgeSegment)edgeSegments.get(secondIdx));
                ++secondIdx;
            }
            ++firstIdx;
        }
        if (this.debugPrefix != null && monitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(monitor, layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, edgeSegments, this.debugPrefix, String.valueOf(sourceLayerIndex) + "-full");
        }
        Random random = (Random)layeredGraph.getProperty(InternalProperties.RANDOM);
        if (criticalDependencyCount >= 2) {
            this.breakCriticalCycles(edgeSegments, random);
        }
        OrthogonalRoutingGenerator.breakNonCriticalCycles(edgeSegments, random);
        if (this.debugPrefix != null && monitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(monitor, layeredGraph, sourceLayerNodes == null ? 0 : sourceLayerIndex + 1, edgeSegments, this.debugPrefix, String.valueOf(sourceLayerIndex) + "-acyclic");
        }
        OrthogonalRoutingGenerator.topologicalNumbering(edgeSegments);
        int rankCount = -1;
        for (HyperEdgeSegment node : edgeSegments) {
            if (Math.abs(node.getStartCoordinate() - node.getEndCoordinate()) < 0.001) continue;
            rankCount = Math.max(rankCount, node.getRoutingSlot());
            this.routingStrategy.calculateBendPoints(node, startPos, this.edgeSpacing);
        }
        this.routingStrategy.clearCreatedJunctionPoints();
        return rankCount + 1;
    }

    private double minimumHorizontalSegmentDistance(List<HyperEdgeSegment> edgeSegments) {
        double minIncomingDistance = this.minimumDifference(edgeSegments.stream().flatMap(segment -> segment.getIncomingConnectionCoordinates().stream()));
        double minOutgoingDistance = this.minimumDifference(edgeSegments.stream().flatMap(segment -> segment.getOutgoingConnectionCoordinates().stream()));
        return Math.min(minIncomingDistance, minOutgoingDistance);
    }

    private double minimumDifference(Stream<Double> numberStream) {
        List numbers = numberStream.sorted().distinct().collect(Collectors.toList());
        double minDifference = Double.MAX_VALUE;
        if (numbers.size() >= 2) {
            Iterator iter = numbers.iterator();
            Double currentNumber = (Double)iter.next();
            while (iter.hasNext()) {
                Double previousNumber = currentNumber;
                currentNumber = (Double)iter.next();
                minDifference = Math.min(minDifference, currentNumber - previousNumber);
            }
        }
        return minDifference;
    }

    private void createHyperEdgeSegments(Iterable<LNode> nodes, PortSide portSide, List<HyperEdgeSegment> hyperEdges, Map<LPort, HyperEdgeSegment> portToHyperEdgeSegmentMap) {
        if (nodes != null) {
            for (LNode node : nodes) {
                for (LPort port : node.getPorts(PortType.OUTPUT, portSide)) {
                    HyperEdgeSegment hyperEdge = portToHyperEdgeSegmentMap.get((Object)port);
                    if (hyperEdge != null) continue;
                    hyperEdge = new HyperEdgeSegment(this.routingStrategy);
                    hyperEdges.add(hyperEdge);
                    hyperEdge.addPortPositions(port, portToHyperEdgeSegmentMap);
                }
            }
        }
    }

    int createDependencyIfNecessary(HyperEdgeSegment he1, HyperEdgeSegment he2) {
        if (Math.abs(he1.getStartCoordinate() - he1.getEndCoordinate()) < 0.001 || Math.abs(he2.getStartCoordinate() - he2.getEndCoordinate()) < 0.001) {
            return 0;
        }
        int conflicts1 = this.countConflicts(he1.getOutgoingConnectionCoordinates(), he2.getIncomingConnectionCoordinates());
        int conflicts2 = this.countConflicts(he2.getOutgoingConnectionCoordinates(), he1.getIncomingConnectionCoordinates());
        boolean criticalConflictsDetected = conflicts1 == -1 || conflicts2 == -1;
        int criticalDependencyCount = 0;
        if (criticalConflictsDetected) {
            if (conflicts1 == -1) {
                HyperEdgeSegmentDependency.createAndAddCritical(he2, he1);
                ++criticalDependencyCount;
            }
            if (conflicts2 == -1) {
                HyperEdgeSegmentDependency.createAndAddCritical(he1, he2);
                ++criticalDependencyCount;
            }
        } else {
            int depValue2;
            int crossings1 = OrthogonalRoutingGenerator.countCrossings(he1.getOutgoingConnectionCoordinates(), he2.getStartCoordinate(), he2.getEndCoordinate());
            int crossings2 = OrthogonalRoutingGenerator.countCrossings(he2.getOutgoingConnectionCoordinates(), he1.getStartCoordinate(), he1.getEndCoordinate());
            int depValue1 = 1 * conflicts1 + 16 * (crossings1 += OrthogonalRoutingGenerator.countCrossings(he2.getIncomingConnectionCoordinates(), he1.getStartCoordinate(), he1.getEndCoordinate()));
            if (depValue1 < (depValue2 = 1 * conflicts2 + 16 * (crossings2 += OrthogonalRoutingGenerator.countCrossings(he1.getIncomingConnectionCoordinates(), he2.getStartCoordinate(), he2.getEndCoordinate())))) {
                HyperEdgeSegmentDependency.createAndAddRegular(he1, he2, depValue2 - depValue1);
            } else if (depValue1 > depValue2) {
                HyperEdgeSegmentDependency.createAndAddRegular(he2, he1, depValue1 - depValue2);
            } else if (depValue1 > 0 && depValue2 > 0) {
                HyperEdgeSegmentDependency.createAndAddRegular(he1, he2, 0);
                HyperEdgeSegmentDependency.createAndAddRegular(he2, he1, 0);
            }
        }
        return criticalDependencyCount;
    }

    private int countConflicts(List<Double> posis1, List<Double> posis2) {
        int conflicts = 0;
        if (!posis1.isEmpty() && !posis2.isEmpty()) {
            Iterator<Double> iter1 = posis1.iterator();
            Iterator<Double> iter2 = posis2.iterator();
            double pos1 = iter1.next();
            double pos2 = iter2.next();
            boolean hasMore = true;
            do {
                if (pos1 > pos2 - this.criticalConflictThreshold && pos1 < pos2 + this.criticalConflictThreshold) {
                    return -1;
                }
                if (pos1 > pos2 - this.conflictThreshold && pos1 < pos2 + this.conflictThreshold) {
                    ++conflicts;
                }
                if (pos1 <= pos2 && iter1.hasNext()) {
                    pos1 = iter1.next();
                    continue;
                }
                if (pos2 <= pos1 && iter2.hasNext()) {
                    pos2 = iter2.next();
                    continue;
                }
                hasMore = false;
            } while (hasMore);
        }
        return conflicts;
    }

    static int countCrossings(List<Double> posis, double start, double end) {
        int crossings = 0;
        for (double pos : posis) {
            if (pos > end) break;
            if (!(pos >= start)) continue;
            ++crossings;
        }
        return crossings;
    }

    private void breakCriticalCycles(List<HyperEdgeSegment> edgeSegments, Random random) {
        List<HyperEdgeSegmentDependency> cycleDependencies = HyperEdgeCycleDetector.detectCycles(edgeSegments, true, random);
        if (this.segmentSplitter == null) {
            this.segmentSplitter = new HyperEdgeSegmentSplitter(this);
        }
        this.segmentSplitter.splitSegments(cycleDependencies, edgeSegments, this.criticalConflictThreshold);
    }

    public static void breakNonCriticalCycles(List<HyperEdgeSegment> edgeSegments, Random random) {
        List<HyperEdgeSegmentDependency> cycleDependencies = HyperEdgeCycleDetector.detectCycles(edgeSegments, false, random);
        for (HyperEdgeSegmentDependency cycleDependency : cycleDependencies) {
            if (cycleDependency.getWeight() == 0) {
                cycleDependency.remove();
                continue;
            }
            cycleDependency.reverse();
        }
    }

    private static void topologicalNumbering(List<HyperEdgeSegment> segments) {
        ArrayList sources = Lists.newArrayList();
        ArrayList rightwardTargets = Lists.newArrayList();
        for (HyperEdgeSegment node2 : segments) {
            node2.setInWeight(node2.getIncomingSegmentDependencies().size());
            node2.setOutWeight(node2.getOutgoingSegmentDependencies().size());
            if (node2.getInWeight() == 0) {
                sources.add(node2);
            }
            if (node2.getOutWeight() != 0 || node2.getIncomingConnectionCoordinates().size() != 0) continue;
            rightwardTargets.add(node2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            HyperEdgeSegment node3 = (HyperEdgeSegment)sources.remove(0);
            for (HyperEdgeSegmentDependency hyperEdgeSegmentDependency : node3.getOutgoingSegmentDependencies()) {
                HyperEdgeSegment target = hyperEdgeSegmentDependency.getTarget();
                target.setRoutingSlot(Math.max(target.getRoutingSlot(), node3.getRoutingSlot() + 1));
                maxRank = Math.max(maxRank, target.getRoutingSlot());
                target.setInWeight(target.getInWeight() - 1);
                if (target.getInWeight() != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (HyperEdgeSegment node : rightwardTargets) {
                node.setRoutingSlot(maxRank);
            }
            while (!rightwardTargets.isEmpty()) {
                HyperEdgeSegment node;
                node = (HyperEdgeSegment)rightwardTargets.remove(0);
                for (HyperEdgeSegmentDependency hyperEdgeSegmentDependency : node.getIncomingSegmentDependencies()) {
                    HyperEdgeSegment source = hyperEdgeSegmentDependency.getSource();
                    if (source.getIncomingConnectionCoordinates().size() > 0) continue;
                    source.setRoutingSlot(Math.min(source.getRoutingSlot(), node.getRoutingSlot() - 1));
                    source.setOutWeight(source.getOutWeight() - 1);
                    if (source.getOutWeight() != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }
}

