/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.layoutoption;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.EnumLayoutOption;
import org.eclipse.sirius.diagram.description.EnumLayoutValue;
import org.eclipse.sirius.diagram.description.LayoutOption;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.editor.Messages;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractComboPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.layoutoption.LayoutOptionPropertiesUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EnumLayoutOptionValuePropertySection
extends AbstractComboPropertySection {
    protected CLabel help;
    protected Button removeOverrideButton;
    private LayoutOption layoutOption;

    public EnumLayoutOptionValuePropertySection(LayoutOption layoutOption) {
        this.layoutOption = layoutOption;
    }

    protected String getDefaultLabelText() {
        return this.layoutOption.getLabel();
    }

    protected String getLabelText() {
        String label = LayoutOptionPropertiesUtils.getLabel((CustomLayoutConfiguration)this.layoutOption.eContainer(), this.layoutOption);
        return label == null ? Messages.LayoutOptionValue_defaultLabel : label;
    }

    protected EReference getFeature() {
        return DescriptionPackage.eINSTANCE.getEnumLayoutOption_Value();
    }

    protected Object getFeatureValue(int index) {
        return this.getFeatureValueAt(index);
    }

    protected boolean isEqual(int index) {
        boolean isEqual = false;
        isEqual = this.getFeatureValueAt(index) == null ? this.eObject.eGet((EStructuralFeature)this.getFeature()) == null : this.getFeatureValueAt(index).equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
        return isEqual;
    }

    protected Object getFeatureValueAt(int index) {
        List<?> values = this.getChoiceOfValues();
        if (values.size() < index || values.size() == 0 || index == -1) {
            return null;
        }
        return values.get(index);
    }

    protected List<?> getChoiceOfValues() {
        CustomLayoutConfiguration layout;
        ArrayList<EnumLayoutValue> result = new ArrayList<EnumLayoutValue>();
        Map layoutProviderRegistry = DiagramUIPlugin.getPlugin().getLayoutAlgorithms();
        CustomLayoutAlgorithm genericLayoutProviderSupplier = (CustomLayoutAlgorithm)layoutProviderRegistry.get((layout = (CustomLayoutConfiguration)this.layoutOption.eContainer()).getId());
        if (genericLayoutProviderSupplier != null) {
            Map layoutOptions = genericLayoutProviderSupplier.getLayoutOptions();
            EnumLayoutOption layoutOptionTemplate = (EnumLayoutOption)layoutOptions.get(this.layoutOption.getId());
            EList choices = layoutOptionTemplate.getChoices();
            EnumLayoutOption layoutOptionEnum = (EnumLayoutOption)this.layoutOption;
            for (EnumLayoutValue enumLayoutValue : choices) {
                boolean alreadyExistingOption;
                boolean bl = alreadyExistingOption = layoutOptionEnum.getValue() != null && enumLayoutValue.getName().equals(layoutOptionEnum.getValue().getName());
                if (!alreadyExistingOption) {
                    result.add((EnumLayoutValue)EcoreUtil.copy((EObject)enumLayoutValue));
                    continue;
                }
                result.add(layoutOptionEnum.getValue());
            }
        }
        return result;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.eObject = this.layoutOption;
        ((FormData)this.combo.getLayoutData()).right = new FormAttachment(94, 0);
        this.removeOverrideButton = LayoutOptionPropertiesUtils.createRemoveOptionButton((Control)this.combo, this.composite, (ViewpointPropertySheetPage)tabbedPropertySheetPage, this.getWidgetFactory(), this.layoutOption);
        this.help = LayoutOptionPropertiesUtils.createHelpLabel(this.getWidgetFactory(), this.composite, (Control)this.combo, (Control)this.nameLabel, this.getHelpIcon(), this.layoutOption);
    }

    public void dispose() {
        if (this.help != null) {
            this.help.dispose();
        }
        if (this.removeOverrideButton != null) {
            this.removeOverrideButton.dispose();
        }
        super.dispose();
    }
}

