/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.common.ICostFunction;
import org.eclipse.elk.alg.common.nodespacing.NodeDimensionCalculation;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.common.utils.Utils;
import org.eclipse.elk.alg.spore.IGraphImporter;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.alg.spore.options.CompactionStrategy;
import org.eclipse.elk.alg.spore.options.RootSelection;
import org.eclipse.elk.alg.spore.options.SpanningTreeCostFunction;
import org.eclipse.elk.alg.spore.options.SporeCompactionOptions;
import org.eclipse.elk.alg.spore.options.TreeConstructionStrategy;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.core.util.adapters.ElkGraphAdapters;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class ElkGraphImporter
implements IGraphImporter<ElkNode> {
    private Graph graph;
    private Map<KVector, Pair<Node, ElkNode>> nodeMap;
    private ElkNode elkGraph;
    private double spacingNodeNode;
    private final ICostFunction centerDistance = e -> e.u.distance(e.v);
    private final ICostFunction minimumRootDistance = e -> Math.min(e.u.distance(this.graph.preferredRoot.vertex), e.v.distance(this.graph.preferredRoot.vertex));
    private final ICostFunction circleUnderlap = e -> {
        Node n1 = (Node)this.nodeMap.get(e.u).getFirst();
        Node n2 = (Node)this.nodeMap.get(e.v).getFirst();
        return e.u.distance(e.v) - e.u.distance(n1.rect.getPosition()) - e.v.distance(n2.rect.getPosition());
    };
    private final ICostFunction rectangleUnderlap = e -> {
        Node n1 = (Node)this.nodeMap.get(e.u).getFirst();
        Node n2 = (Node)this.nodeMap.get(e.v).getFirst();
        return n1.underlap(n2);
    };
    private final ICostFunction invertedOverlap = e -> {
        Node n1 = (Node)this.nodeMap.get(e.u).getFirst();
        Node n2 = (Node)this.nodeMap.get(e.v).getFirst();
        ElkRectangle r1 = n1.rect;
        ElkRectangle r2 = n2.rect;
        double dist = ElkMath.shortestDistance((ElkRectangle)r1, (ElkRectangle)r2);
        if (dist >= 0.0) {
            return dist;
        }
        double s = r2.getCenter().sub(r1.getCenter()).length();
        return -(Utils.overlap((ElkRectangle)r1, (ElkRectangle)r2) - 1.0) * s;
    };

    @Override
    public Graph importGraph(ElkNode inputGraph) {
        this.elkGraph = inputGraph;
        this.nodeMap = Maps.newHashMap();
        ElkGraphAdapters.ElkGraphAdapter adapter = ElkGraphAdapters.adapt((ElkNode)this.elkGraph);
        NodeDimensionCalculation.calculateNodeMargins((GraphAdapters.GraphAdapter)adapter);
        String preferredRootID = (String)this.elkGraph.getProperty(SporeCompactionOptions.PROCESSING_ORDER_PREFERRED_ROOT);
        SpanningTreeCostFunction costFunctionID = (SpanningTreeCostFunction)((Object)this.elkGraph.getProperty(SporeCompactionOptions.PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION));
        TreeConstructionStrategy treeConstructionStrategy = (TreeConstructionStrategy)((Object)this.elkGraph.getProperty(SporeCompactionOptions.PROCESSING_ORDER_TREE_CONSTRUCTION));
        CompactionStrategy compactionStrategy = (CompactionStrategy)((Object)this.elkGraph.getProperty(SporeCompactionOptions.COMPACTION_COMPACTION_STRATEGY));
        RootSelection rootSelection = (RootSelection)((Object)this.elkGraph.getProperty(SporeCompactionOptions.PROCESSING_ORDER_ROOT_SELECTION));
        this.spacingNodeNode = (Double)this.elkGraph.getProperty(SporeCompactionOptions.SPACING_NODE_NODE);
        ICostFunction costFunction = this.centerDistance;
        switch (costFunctionID) {
            case CENTER_DISTANCE: {
                costFunction = this.centerDistance;
                break;
            }
            case CIRCLE_UNDERLAP: {
                costFunction = this.circleUnderlap;
                break;
            }
            case RECTANGLE_UNDERLAP: {
                costFunction = this.rectangleUnderlap;
                break;
            }
            case INVERTED_OVERLAP: {
                costFunction = this.invertedOverlap;
                break;
            }
            case MINIMUM_ROOT_DISTANCE: {
                costFunction = this.minimumRootDistance;
                break;
            }
            default: {
                throw new IllegalArgumentException("No implementation available for " + costFunctionID.toString());
            }
        }
        this.graph = new Graph(costFunction, treeConstructionStrategy, compactionStrategy);
        this.graph.setProperty(InternalProperties.DEBUG_SVG, (Boolean)this.elkGraph.getProperty(SporeCompactionOptions.DEBUG_MODE));
        this.graph.orthogonalCompaction = (Boolean)this.elkGraph.getProperty(SporeCompactionOptions.COMPACTION_ORTHOGONAL);
        if (this.elkGraph.getChildren().isEmpty()) {
            return this.graph;
        }
        for (ElkNode elkNode : this.elkGraph.getChildren()) {
            double halfWidth = elkNode.getWidth() / 2.0;
            double halfHeight = elkNode.getHeight() / 2.0;
            KVector vertex = new KVector(elkNode.getX() + halfWidth, elkNode.getY() + halfHeight);
            while (this.nodeMap.containsKey(vertex)) {
                vertex.add((Math.random() - 0.5) * 0.001, (Math.random() - 0.5) * 0.001);
            }
            ElkMargin margin = (ElkMargin)elkNode.getProperty(CoreOptions.MARGINS);
            Node node = new Node(vertex, new ElkRectangle(vertex.x - halfWidth - this.spacingNodeNode / 2.0 - margin.left, vertex.y - halfHeight - this.spacingNodeNode / 2.0 - margin.top, elkNode.getWidth() + this.spacingNodeNode + margin.getHorizontal(), elkNode.getHeight() + this.spacingNodeNode + margin.getVertical()));
            this.graph.vertices.add(node);
            this.nodeMap.put(vertex, (Pair<Node, ElkNode>)Pair.of((Object)node, (Object)elkNode));
        }
        switch (rootSelection) {
            case FIXED: {
                if (preferredRootID == null) {
                    this.graph.preferredRoot = this.graph.vertices.get(0);
                    break;
                }
                for (Node node : this.graph.vertices) {
                    String id = ((ElkNode)this.nodeMap.get(node.originalVertex).getSecond()).getIdentifier();
                    if (id == null || !id.equals(preferredRootID)) continue;
                    this.graph.preferredRoot = node;
                }
                break;
            }
            case CENTER_NODE: {
                KVector center = new KVector(this.elkGraph.getWidth(), this.elkGraph.getHeight());
                center.scale(0.5);
                center.add(this.elkGraph.getX(), this.elkGraph.getY());
                double closest = Double.POSITIVE_INFINITY;
                for (Node node : this.graph.vertices) {
                    double distance = node.originalVertex.distance(center);
                    if (!(distance < closest)) continue;
                    closest = distance;
                    this.graph.preferredRoot = node;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No implementation available for " + rootSelection.toString());
            }
        }
        return this.graph;
    }

    @Override
    public void updateGraph(Graph g) {
        HashMap updatedNodeMap = Maps.newHashMap();
        g.tEdges = null;
        g.tree = null;
        for (Node n : g.vertices) {
            Pair<Node, ElkNode> original = this.nodeMap.get(n.originalVertex);
            n.originalVertex = n.rect.getCenter();
            updatedNodeMap.put(n.originalVertex, original);
        }
        this.nodeMap = updatedNodeMap;
    }

    @Override
    public void applyPositions(Graph g) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Node node : g.vertices) {
            ElkNode elkNode = (ElkNode)this.nodeMap.get(node.originalVertex).getSecond();
            elkNode.setLocation(node.rect.x, node.rect.y);
            minX = Math.min(minX, elkNode.getX());
            minY = Math.min(minY, elkNode.getY());
            maxX = Math.max(maxX, elkNode.getX() + elkNode.getWidth());
            maxY = Math.max(maxY, elkNode.getY() + elkNode.getHeight());
        }
        ElkPadding padding = (ElkPadding)this.elkGraph.getProperty(SporeCompactionOptions.PADDING);
        ElkUtil.resizeNode((ElkNode)this.elkGraph, (double)(maxX - minX + padding.getHorizontal()), (double)(maxY - minY + padding.getVertical()), (boolean)true, (boolean)true);
        ElkUtil.translate((ElkNode)this.elkGraph, (double)(-minX + padding.left), (double)(-minY + padding.top));
        for (ElkEdge e : this.elkGraph.getContainedEdges()) {
            ElkEdgeSection kedgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)e, (boolean)true, (boolean)true);
            ElkNode source = ElkGraphUtil.getSourceNode((ElkEdge)e);
            ElkNode target = ElkGraphUtil.getTargetNode((ElkEdge)e);
            KVector startLocation = new KVector(source.getX() + source.getWidth() / 2.0, source.getY() + source.getHeight() / 2.0);
            KVector endLocation = new KVector(target.getX() + target.getWidth() / 2.0, target.getY() + target.getHeight() / 2.0);
            KVector uv = endLocation.clone().sub(startLocation);
            ElkMath.clipVector((KVector)uv, (double)source.getWidth(), (double)source.getHeight());
            startLocation.add(uv);
            KVector vu = startLocation.clone().sub(endLocation);
            ElkMath.clipVector((KVector)vu, (double)target.getWidth(), (double)target.getHeight());
            endLocation.add(vu);
            kedgeSection.setStartLocation(startLocation.x, startLocation.y);
            kedgeSection.setEndLocation(endLocation.x, endLocation.y);
        }
    }
}

