/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusResizeTracker;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.CenterEditPartEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChangeBendpointsOfEdgesCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChildrenAdjustmentCommand;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.viewpoint.Style;

public class AirResizableEditPolicy
extends ResizableShapeEditPolicy {
    protected ResizeTracker getResizeTracker(int direction) {
        return new SiriusResizeTracker((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getHost()), direction);
    }

    protected Command getAutoSizeCommand(Request request) {
        DNode node;
        NodeStyle nodeStyle;
        EObject eObject;
        if (this.getHost() instanceof IDiagramNodeEditPart && (eObject = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement()) instanceof DNode && (nodeStyle = (NodeStyle)(node = (DNode)eObject).getStyle()) != null && nodeStyle.getLabelPosition() == LabelPosition.NODE_LITERAL && !new DNodeQuery(node).isAutoSize()) {
            DNode viewNode = (DNode)eObject;
            SiriusWrapLabel label = ((IDiagramNodeEditPart)this.getHost()).getNodeLabel();
            Style style = viewNode.getStyle();
            DiagramElementMapping mapping = viewNode.getDiagramElementMapping();
            DefaultSizeNodeFigure defaultSizeNodeFigure = (DefaultSizeNodeFigure)((IDiagramNodeEditPart)this.getHost()).getMainFigure();
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(mapping, style);
            Dimension newDim = styleConfiguration.fitToText(viewNode, label, defaultSizeNodeFigure);
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)viewNode);
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(transactionalEditingDomain, Messages.AirResizableEditPolicy_autoSizeCommandLabel, (IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)this.getHost()).getNotationView()), newDim);
            return new ICommandProxy((ICommand)setBoundsCommand);
        }
        return super.getAutoSizeCommand(request);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        Command result = super.getMoveCommand(request);
        if (this.getHost().getParent() != null) {
            if (this.getHost() instanceof IGraphicalEditPart) {
                IGraphicalEditPart hostPart = (IGraphicalEditPart)this.getHost();
                CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(hostPart.getEditingDomain(), result.getLabel());
                ctc.add((IUndoableOperation)new CommandProxy(result));
                ctc.add((IUndoableOperation)new ChangeBendpointsOfEdgesCommand(hostPart, new PrecisionPoint(request.getMoveDelta())));
                result = new ICommandProxy((ICommand)ctc);
            }
            return result;
        }
        return null;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        Command result = super.getAlignCommand(request);
        Point delta = request.getMoveDelta();
        if (this.getHost() instanceof AbstractGraphicalEditPart) {
            PrecisionRectangle locationAndSize = new PrecisionRectangle(((AbstractGraphicalEditPart)this.getHost()).getFigure().getBounds());
            ((AbstractGraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)locationAndSize);
            Rectangle newLocationAndSize = request.getTransformedRectangle((Rectangle)locationAndSize);
            delta = newLocationAndSize.getTopLeft().getTranslated(locationAndSize.getTopLeft().getNegated());
        }
        if (this.getHost() instanceof IGraphicalEditPart) {
            IGraphicalEditPart hostPart = (IGraphicalEditPart)this.getHost();
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(hostPart.getEditingDomain(), result.getLabel());
            ctc.add((IUndoableOperation)new CommandProxy(result));
            ctc.add((IUndoableOperation)new ChangeBendpointsOfEdgesCommand(hostPart, new PrecisionPoint(delta), true));
            result = new ICommandProxy((ICommand)ctc);
        }
        return result;
    }

    protected List createSelectionHandles() {
        List selectionHandles = super.createSelectionHandles();
        for (Object selectionHandle : selectionHandles) {
            if (!(selectionHandle instanceof MoveHandle)) continue;
            ((MoveHandle)selectionHandle).setDragTracker((DragTracker)new NoCopyDragEditPartsTrackerEx((EditPart)this.getHost()));
        }
        return selectionHandles;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ICommand solution;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid && (solution = this.buildResizeCommand(request)) != null) {
            result = new ICommandProxy(solution);
        }
        return result;
    }

    private ICommand buildResizeCommand(ChangeBoundsRequest request) {
        CommandProxy result = null;
        Command cmd = super.getResizeCommand(request);
        if (this.getHost() instanceof IGraphicalEditPart) {
            CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), cmd.getLabel());
            ctc.add((IUndoableOperation)new CommandProxy(cmd));
            this.completeResizeCommand(ctc, request);
            ctc.add((IUndoableOperation)new CenterEditPartEdgesCommand((IGraphicalEditPart)this.getHost(), request));
            result = ctc;
        } else if (cmd != null) {
            result = new CommandProxy(cmd);
        }
        return result;
    }

    protected void completeResizeCommand(CompositeTransactionalCommand ctc, ChangeBoundsRequest request) {
        ctc.add((IUndoableOperation)new ChildrenAdjustmentCommand((IGraphicalEditPart)this.getHost(), request));
    }
}

