/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class CenterEditPartEdgesCommand
extends AbstractTransactionalCommand {
    private IGraphicalEditPart editPart;
    private ChangeBoundsRequest request;

    public CenterEditPartEdgesCommand(IGraphicalEditPart graphicalEditPart, ChangeBoundsRequest request) {
        super(graphicalEditPart.getEditingDomain(), Messages.CenterEditPartEdgesCommand_label, null);
        this.editPart = graphicalEditPart;
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList edges = new ArrayList();
        edges.addAll(this.editPart.getSourceConnections());
        edges.addAll(this.editPart.getTargetConnections());
        for (ConnectionEditPart connection : Iterables.filter(edges, ConnectionEditPart.class)) {
            Object model = connection.getModel();
            if (!(model instanceof Edge)) continue;
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation((Edge)model, false);
            if (this.request != null) {
                PrecisionDimension newSourceSize = this.getNewSize(connection.getSource());
                PrecisionDimension newTargetSize = this.getNewSize(connection.getTarget());
                centerEdgeEndModelChangeOperation.setSourceAndTargetSize((Dimension)newSourceSize, (Dimension)newTargetSize);
            }
            centerEdgeEndModelChangeOperation.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    private PrecisionDimension getNewSize(EditPart edgeEnd) {
        if (edgeEnd instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)edgeEnd).getFigure();
            PrecisionRectangle newBounds = new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)newBounds);
            List editPartRequesting = this.request.getEditParts();
            if (editPartRequesting.contains(edgeEnd)) {
                newBounds = new PrecisionRectangle(this.request.getTransformedRectangle((Rectangle)newBounds));
            }
            figure.translateToRelative((Translatable)newBounds);
            return new PrecisionDimension(newBounds.preciseWidth(), newBounds.preciseHeight());
        }
        return null;
    }

    public void dispose() {
        this.editPart = null;
        this.request = null;
        super.dispose();
    }
}

