/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.helper;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class SiriusResourceHelper {
    private SiriusResourceHelper() {
    }

    private static boolean sameURIs(Resource referenceResource, Resource ressource) {
        URI referenceURI;
        if (referenceResource != null && ressource != null && (referenceURI = referenceResource.getURI()) != null) {
            return referenceURI.equals(ressource.getURI());
        }
        return false;
    }

    public static void createViews(Session session, List<Viewpoint> registryViewpoints, ResourceSet editingDomainResourceSet, EObject semanticElement) {
        for (Viewpoint registryViewpoint : registryViewpoints) {
            Resource editingDomainResource = editingDomainResourceSet.getResource(registryViewpoint.eResource().getURI(), true);
            try {
                editingDomainResource.load(Collections.EMPTY_MAP);
                Viewpoint editingDomainViewpoint = SiriusUtil.findViewpoint(editingDomainResource, registryViewpoint.getName());
                if (editingDomainViewpoint == null) continue;
                session.createView(editingDomainViewpoint, Collections.singleton(semanticElement), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException iOException) {}
        }
    }

    public static Viewpoint getCorrespondingViewpoint(Session session, Viewpoint registryViewpoint) {
        Viewpoint editingDomainViewpoint = null;
        Resource registryViewpointResource = null;
        TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
        Iterator iterator = domain.getResourceSet().getResources().iterator();
        while (iterator.hasNext() && editingDomainViewpoint == null) {
            Resource editingDomainResource = (Resource)iterator.next();
            if (Boolean.valueOf(System.getProperty("org.eclipse.sirius.enableUnsafeOptimisations", "false")).booleanValue() && !"odesign".equals(editingDomainResource.getURI().fileExtension())) continue;
            try {
                editingDomainResource.load(Collections.EMPTY_MAP);
                registryViewpointResource = registryViewpoint.eResource();
                if (!SiriusResourceHelper.sameURIs(registryViewpointResource, editingDomainResource)) continue;
                editingDomainViewpoint = SiriusUtil.findViewpoint(editingDomainResource, registryViewpoint.getName());
            }
            catch (Resource.IOWrappedException iOWrappedException) {
                iterator.remove();
            }
            catch (IOException iOException) {}
        }
        if (editingDomainViewpoint == null) {
            if (registryViewpointResource == null) {
                registryViewpointResource = registryViewpoint.eResource();
            }
            Resource editingDomainResource = domain.getResourceSet().getResource(registryViewpointResource.getURI(), true);
            try {
                editingDomainResource.load(Collections.EMPTY_MAP);
                editingDomainViewpoint = SiriusUtil.findViewpoint(editingDomainResource, registryViewpoint.getName());
            }
            catch (IOException iOException) {}
        }
        return editingDomainViewpoint;
    }

    public static boolean isViewExistForSirius(Session session, Viewpoint editingDomainViewpoint) {
        DAnalysis mainDAnalysis = (DAnalysis)session.getSessionResource().getContents().get(0);
        for (DView view : mainDAnalysis.getOwnedViews()) {
            if (view.getViewpoint() == null || !view.getViewpoint().equals(editingDomainViewpoint)) continue;
            return true;
        }
        return false;
    }
}

