/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.enterprise.inject.Typed;
import javax.inject.Provider;
import org.eclipse.sisu.EagerSingleton;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.Legacy;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.space.MediationListener;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.WildcardKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private static final TypeLiteral<?> OBJECT_TYPE_LITERAL;
    private static final boolean HAS_TYPED;
    private final Binder rootBinder;
    private MediationListener mediationListener;
    private Object currentSource;
    private Binder binder;

    static {
        boolean hasTyped;
        try {
            hasTyped = Typed.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasTyped = false;
        }
        HAS_TYPED = hasTyped;
        OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    }

    public QualifiedTypeBinder(Binder binder) {
        this.rootBinder = binder;
        this.binder = binder;
    }

    public void hear(Class qualifiedType, Object source) {
        if (this.currentSource != source) {
            if (source != null) {
                this.binder = this.rootBinder.withSource(source);
                this.currentSource = source;
            } else {
                this.binder = this.rootBinder;
                this.currentSource = null;
            }
        }
        if (!TypeArguments.isConcrete(qualifiedType)) {
            return;
        }
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else if (org.sonatype.inject.Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerLegacyMediator(qualifiedType);
        } else if (Provider.class.isAssignableFrom(qualifiedType)) {
            this.bindProviderType(qualifiedType);
        } else {
            this.bindQualifiedType(qualifiedType);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (module != null) {
            this.binder.install(module);
        }
    }

    private void registerMediator(Class<Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = this.newInstance(mediatorType);
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void registerLegacyMediator(Class<org.sonatype.inject.Mediator> mediatorType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(mediatorType, org.sonatype.inject.Mediator.class);
        if (args.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator mediator = Legacy.adapt(this.newInstance(mediatorType));
            if (mediator != null) {
                this.mediate(QualifiedTypeBinder.watchedKey(args[1], args[0].getRawType()), mediator, args[2].getRawType());
            }
        }
    }

    private void mediate(Key watchedKey, Mediator mediator, Class watcherType) {
        if (this.mediationListener == null) {
            this.mediationListener = new MediationListener(this.binder);
            this.binder.bindListener((Matcher)this.mediationListener, (TypeListener)this.mediationListener);
        }
        this.mediationListener.mediate(watchedKey, mediator, watcherType);
    }

    private void bindProviderType(Class<?> providerType) {
        TypeLiteral<?>[] args = QualifiedTypeBinder.resolveTypeArguments(providerType, Provider.class);
        if (args.length != 1) {
            this.binder.addError(providerType + " has wrong number of type arguments", new Object[0]);
        } else {
            this.binder.bind(providerType).in(Scopes.SINGLETON);
            Named bindingName = QualifiedTypeBinder.getBindingName(providerType);
            Class<?>[] types = QualifiedTypeBinder.getBindingTypes(providerType);
            Key<?> key = QualifiedTypeBinder.getBindingKey(args[0], (Annotation)bindingName);
            ScopedBindingBuilder sbb = this.binder.bind(key).toProvider(providerType);
            if (QualifiedTypeBinder.isEagerSingleton(providerType)) {
                sbb.asEagerSingleton();
            } else if (QualifiedTypeBinder.isSingleton(providerType)) {
                sbb.in(Scopes.SINGLETON);
            }
            if (types != null) {
                Class<?>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> bindingType = classArray[n2];
                    this.binder.bind(key.ofType(bindingType)).to(key);
                    ++n2;
                }
            }
        }
    }

    private void bindQualifiedType(Class<?> qualifiedType) {
        AnnotatedBindingBuilder sbb = this.binder.bind(qualifiedType);
        if (QualifiedTypeBinder.isEagerSingleton(qualifiedType)) {
            sbb.asEagerSingleton();
        }
        Named bindingName = QualifiedTypeBinder.getBindingName(qualifiedType);
        Class<?>[] types = QualifiedTypeBinder.getBindingTypes(qualifiedType);
        if (types != null) {
            Key<?> key = QualifiedTypeBinder.getBindingKey(OBJECT_TYPE_LITERAL, (Annotation)bindingName);
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> bindingType = classArray[n2];
                this.binder.bind(key.ofType(bindingType)).to(qualifiedType);
                ++n2;
            }
        } else {
            this.binder.bind((Key)new WildcardKey(qualifiedType, (Annotation)bindingName)).to(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            this.binder.addError("Error creating instance of: " + type + " reason: " + cause, new Object[0]);
            return null;
        }
        catch (LinkageError e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] resolveTypeArguments(Class<?> type, Class<?> superType) {
        return TypeArguments.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static <T> Key<T> getBindingKey(TypeLiteral<T> bindingType, Annotation qualifier) {
        return qualifier != null ? Key.get(bindingType, (Annotation)qualifier) : Key.get(bindingType);
    }

    private static Named getBindingName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (jsr330 != null) {
            try {
                String name = jsr330.value();
                if (name.length() > 0) {
                    return "default".equals(name) ? null : Names.named((String)name);
                }
            }
            catch (IncompleteAnnotationException incompleteAnnotationException) {}
        } else {
            String name;
            Named guice = qualifiedType.getAnnotation(Named.class);
            if (guice != null && (name = guice.value()).length() > 0) {
                return "default".equals(name) ? null : guice;
            }
        }
        if (qualifiedType.getSimpleName().startsWith("Default")) {
            return null;
        }
        return Names.named((String)qualifiedType.getName());
    }

    private static Class<?>[] getBindingTypes(Class<?> clazz) {
        if (HAS_TYPED) {
            Class<?> c = clazz;
            while (c != Object.class) {
                Typed typed = c.getAnnotation(Typed.class);
                if (typed != null) {
                    return typed.value().length > 0 ? typed.value() : c.getInterfaces();
                }
                c = c.getSuperclass();
            }
        }
        return null;
    }

    private static boolean isSingleton(Class<?> type) {
        return type.isAnnotationPresent(javax.inject.Singleton.class) || type.isAnnotationPresent(Singleton.class);
    }

    private static boolean isEagerSingleton(Class<?> type) {
        return type.isAnnotationPresent(EagerSingleton.class) || type.isAnnotationPresent(org.sonatype.inject.EagerSingleton.class);
    }

    private static <T> Key<T> watchedKey(TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        return Annotation.class != annotationType ? Key.get(type, annotationType) : Key.get(type);
    }
}

