/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.processing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingUI;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;

@NonNullByDefault
public class DocActionUtil
extends ActionUtil<IFile> {
    private @Nullable IContentType contentType;

    public DocActionUtil(byte initialMode) {
        super(initialMode);
    }

    public void setContentType(IContentType contentType) {
        this.contentType = contentType;
    }

    public @Nullable IFile getLaunchElement(@Nullable IEditorPart editor) {
        IResource resource = null;
        if (editor instanceof ISourceEditor) {
            resource = this.getSingleResource(editor.getEditorInput());
        }
        return resource instanceof IFile ? (IFile)resource : null;
    }

    public @Nullable IFile getLaunchElement(@Nullable ISelection selection) {
        IResource resource = null;
        if (selection instanceof IStructuredSelection) {
            resource = this.getSingleResource((IStructuredSelection)selection);
        }
        return resource instanceof IFile ? (IFile)resource : null;
    }

    public @Nullable LaunchConfigManager<IFile> getManager(IWorkbenchWindow window, IFile element) {
        return this.getManager(this.getContentType(window, element));
    }

    public @Nullable IContentType getContentType(IWorkbenchWindow window, @Nullable IFile element) {
        IContentType contentType = this.contentType;
        if (contentType == null) {
            switch (this.getMode()) {
                case 1: {
                    IEditorPart activeEditor;
                    if (window == null || !((activeEditor = window.getActivePage().getActiveEditor()) instanceof ISourceEditor)) break;
                    contentType = ((ISourceEditor)activeEditor).getContentType();
                    break;
                }
                case 2: {
                    if (element == null) break;
                    try {
                        IContentDescription contentDescription = element.getContentDescription();
                        if (contentDescription == null) break;
                        contentType = contentDescription.getContentType();
                    }
                    catch (CoreException coreException) {}
                    break;
                }
            }
        }
        return contentType;
    }

    public @Nullable DocProcessingManager getManager(@Nullable IContentType contentType) {
        return contentType != null ? DocProcessingUI.getDocProcessingManager(contentType, true) : null;
    }
}

