/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ForwardLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;

public abstract class TransformLayer
extends ForwardLayer {
    public TransformLayer(ILayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    protected abstract void initDims();

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerCell underlyingCell = this.getUnderlyingLayer().getCellByPosition(this.getDim(Orientation.HORIZONTAL).localToUnderlyingPosition(columnPosition, columnPosition), this.getDim(Orientation.VERTICAL).localToUnderlyingPosition(rowPosition, rowPosition));
        return this.createCell(this.transformCellDim(underlyingCell.getDim(Orientation.HORIZONTAL), columnPosition), this.transformCellDim(underlyingCell.getDim(Orientation.VERTICAL), rowPosition), underlyingCell);
    }

    protected ILayerCellDim transformCellDim(ILayerCellDim underlyingDim, long position) {
        if (underlyingDim.getPosition() == position) {
            return underlyingDim;
        }
        long originPosition = position - (underlyingDim.getPosition() - underlyingDim.getOriginPosition());
        return new LayerCellDim(underlyingDim.getOrientation(), underlyingDim.getId(), position, originPosition, underlyingDim.getPositionSpan());
    }
}

