/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.tex.r.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.statet.docmlet.tex.core.TexCodeStyleSettings;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.util.TexCoreAccessWrapper;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.util.RCoreAccessWrapper;
import org.eclipse.statet.redocs.tex.r.core.source.LtxRweaveDocumentSetupParticipant;
import org.eclipse.statet.redocs.tex.r.ui.sourceediting.LtxRweaveSourceViewerConfiguration;

public class LtxRweaveSourceViewerConfigurator
extends SourceEditorViewerConfigurator {
    private static final Set<String> RESET_GROUP_IDS = new HashSet<String>(Arrays.asList("tex/tex.codestyle/indent", "r/r.codestyle/indent", "statet.task_tags"));
    private final TexCoreAccessWrapper docCoreAccess;
    private final RCoreAccessWrapper rCoreAccess;

    public LtxRweaveSourceViewerConfigurator(TexCoreAccess texCoreAccess, RCoreAccess rCoreAccess, LtxRweaveSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        this.docCoreAccess = new TexCoreAccessWrapper(texCoreAccess){
            private final TexCodeStyleSettings codeStyle;
            {
                this.codeStyle = new TexCodeStyleSettings(1);
            }

            public TexCodeStyleSettings getTexCodeStyle() {
                return this.codeStyle;
            }
        };
        this.rCoreAccess = new RCoreAccessWrapper(rCoreAccess){
            private final RCodeStyleSettings codeStyle;
            {
                this.codeStyle = new RCodeStyleSettings(1);
            }

            public RCodeStyleSettings getRCodeStyle() {
                return this.codeStyle;
            }
        };
        config.setCoreAccess((TexCoreAccess)this.docCoreAccess, (RCoreAccess)this.rCoreAccess);
        this.docCoreAccess.getTexCodeStyle().load(this.docCoreAccess.getParent().getTexCodeStyle());
        this.docCoreAccess.getTexCodeStyle().resetDirty();
        this.docCoreAccess.getTexCodeStyle().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        this.rCoreAccess.getRCodeStyle().resetDirty();
        this.rCoreAccess.getRCodeStyle().addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public final TexCoreAccess getTexCoreAccess() {
        return this.docCoreAccess;
    }

    public final RCoreAccess getRCoreAccess() {
        return this.rCoreAccess;
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new LtxRweaveDocumentSetupParticipant();
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(TexCoreAccess texCoreAccess, RCoreAccess rCoreAccess) {
        boolean changed = false;
        if (texCoreAccess != null) {
            changed |= this.docCoreAccess.setParent(texCoreAccess);
        }
        if (rCoreAccess != null) {
            changed |= this.rCoreAccess.setParent(rCoreAccess);
        }
        if (changed) {
            this.handleSettingsChanged(null, null);
        }
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.docCoreAccess.getTexCodeStyle().resetDirty();
        this.rCoreAccess.getRCodeStyle().resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("tex/tex.codestyle/indent")) {
            this.docCoreAccess.getTexCodeStyle().load(this.docCoreAccess.getParent().getTexCodeStyle());
        }
        if (groupIds.contains("r/r.codestyle/indent") || groupIds.contains("r/r.codestyle/ws")) {
            this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.redocs.tex.r/editor/Ltx")) {
            this.updateCompleteConfig = true;
        }
        if (groupIds.contains("r/r.editor/hover")) {
            this.updateInfoHovers = true;
        }
    }
}

