/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultEvictionPolicy;
import org.apache.commons.pool2.impl.EvictionConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.eclipse.statet.internal.rj.servi.APool2NodeFactory;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.servi.pool.PoolConfig;

@NonNullByDefault
public class APool2
extends GenericObjectPool<APool2NodeHandler> {
    private static final byte CLOSING = 2;
    private static final byte CLOSING_FINALLY = 3;
    private static final byte CLOSED = 4;
    private static final EvictionPolicy<APool2NodeHandler> EVICTION_POLICY = new DefaultEvictionPolicy<APool2NodeHandler>(){

        public boolean evict(EvictionConfig config, PooledObject<APool2NodeHandler> underTest, int idleCount) {
            return super.evict(config, underTest, idleCount) || ((APool2NodeHandler)underTest.getObject()).isEvictRequested(0L);
        }
    };
    private final APool2NodeFactory factory;
    private volatile byte state;
    private boolean evicting;
    private final Object stateLock = new Object();

    private static GenericObjectPoolConfig<APool2NodeHandler> createAConfig(PoolConfig config) {
        GenericObjectPoolConfig aConfig = new GenericObjectPoolConfig();
        aConfig.setLifo(true);
        aConfig.setTestOnReturn(true);
        aConfig.setTestWhileIdle(false);
        aConfig.setTestOnBorrow(false);
        aConfig.setBlockWhenExhausted(true);
        aConfig.setMaxTotal(config.getMaxTotalCount());
        aConfig.setMaxWaitMillis(config.getMaxWaitTime());
        aConfig.setMinIdle(config.getMinIdleCount());
        aConfig.setMaxIdle(config.getMaxIdleCount());
        aConfig.setMinEvictableIdleTimeMillis(0L);
        aConfig.setSoftMinEvictableIdleTimeMillis(config.getMinIdleTime());
        aConfig.setTimeBetweenEvictionRunsMillis(5000L);
        aConfig.setNumTestsPerEvictionRun(-4);
        aConfig.setEvictorShutdownTimeoutMillis(0L);
        return aConfig;
    }

    public APool2(APool2NodeFactory factory, PoolConfig config) {
        super((PooledObjectFactory)factory, APool2.createAConfig(config));
        factory.setPool(this);
        this.factory = factory;
    }

    public void setConfig(PoolConfig config) {
        this.setConfig(APool2.createAConfig(config));
    }

    public APool2NodeHandler borrowObject(String client) throws Exception {
        if (this.state != 0) {
            throw new IllegalStateException("Pool not open");
        }
        this.factory.registerArgs(client);
        try {
            APool2NodeHandler aPool2NodeHandler = (APool2NodeHandler)super.borrowObject();
            return aPool2NodeHandler;
        }
        finally {
            this.factory.clearArgs();
        }
    }

    public int getMinIdle() {
        if (this.state != 0) {
            return 0;
        }
        return super.getMinIdle();
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long evictionTimeout) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state > 2) {
                return;
            }
            this.state = (byte)2;
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clear();
        long evictNanos = APool2NodeHandler.evictNanos(evictionTimeout);
        boolean evictDirect = evictionTimeout == 0L;
        ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
        for (APool2NodeHandler poolObj : objects) {
            poolObj.doEvict(evictNanos, evictDirect);
        }
        if (this.state > 2) {
            return;
        }
        this.setNumTestsPerEvictionRun(512);
        this.setTimeBetweenEvictionRunsMillis(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFinally() {
        super.close();
        Object object = this.stateLock;
        synchronized (object) {
            this.state = (byte)4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() throws Exception {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state > 2 || this.evicting) {
                return;
            }
            this.evicting = true;
        }
        try {
            int evicted;
            do {
                evicted = 0;
                long nanos = APool2NodeHandler.safeNanos(System.nanoTime());
                ImList<APool2NodeHandler> objects = this.factory.getAllObjects();
                for (APool2NodeHandler poolObj : objects) {
                    if (!poolObj.isEvictRequested(nanos)) continue;
                    try {
                        ++evicted;
                        this.invalidateObject(poolObj);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            } while (evicted > 0);
            super.evict();
            Object object2 = this.stateLock;
            synchronized (object2) {
                block16: {
                    if (this.state == 2 && this.factory.getNumAll() <= 0) break block16;
                    return;
                }
                this.state = (byte)3;
            }
            this.closeFinally();
        }
        finally {
            this.evicting = false;
        }
    }

    public EvictionPolicy<APool2NodeHandler> getEvictionPolicy() {
        return EVICTION_POLICY;
    }
}

