/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import com.ibm.icu.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class UIUtils {
    public static void sortConfigs(List<AutoConfig> configs) {
        Collections.sort(configs, new AutoConfigComparator());
    }

    public static void sortTasks(List<Task> configs) {
        Collections.sort(configs, new TaskComparator());
    }

    public static ViewerUtils.CheckboxTableComposite createContentTypeTable(Composite parent, int hSpan) {
        ViewerUtils.CheckboxTableComposite tableComposite = new ViewerUtils.CheckboxTableComposite(parent, 67616);
        GridData gd = new GridData(4, 4, true, true, hSpan, 1);
        Dialog.applyDialogFont((Control)tableComposite);
        gd.heightHint = tableComposite.table.getHeaderHeight() + tableComposite.table.getItemHeight() * 10;
        tableComposite.setLayoutData((Object)gd);
        tableComposite.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableComposite.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = tableComposite.addColumn("Content Type", 16384, (ColumnLayoutData)new ColumnWeightData(5, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                AutoConfig config = (AutoConfig)cell.getElement();
                cell.setText(config.getLabel());
            }
        });
        column = tableComposite.addColumn("Project Configuration", 16384, (ColumnLayoutData)new ColumnWeightData(5, true));
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                AutoConfig config = (AutoConfig)cell.getElement();
                List<Task> tasks = config.getTasks();
                if (tasks.size() == 1) {
                    cell.setText(tasks.get(0).getLabel());
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(tasks.get(0).getLabel());
                    int i = 1;
                    while (i < tasks.size()) {
                        sb.append(" + ");
                        sb.append(tasks.get(i).getLabel());
                        ++i;
                    }
                    cell.setText(sb.toString());
                }
            }
        });
        return tableComposite;
    }

    private static class AutoConfigComparator
    implements Comparator<AutoConfig> {
        private final Collator collator = Collator.getInstance();

        private AutoConfigComparator() {
        }

        @Override
        public int compare(AutoConfig o1, AutoConfig o2) {
            return this.collator.compare(o1.getLabel(), o2.getLabel());
        }
    }

    private static class TaskComparator
    implements Comparator<Task> {
        private final Collator collator = Collator.getInstance();

        private TaskComparator() {
        }

        @Override
        public int compare(Task o1, Task o2) {
            return this.collator.compare(o1.getLabel(), o2.getLabel());
        }
    }
}

