/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.eutils.autonature.Activator;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.internal.eutils.autonature.ContentFinder;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.internal.eutils.autonature.TaskProcessor;
import org.eclipse.statet.internal.eutils.autonature.wizards.ConfigureProjectWizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConfigureProjectWizard
extends Wizard {
    private final IProject project;
    private final ConfigManager configManager;
    private ConfigureProjectWizardPage configPage;
    private List<Task> allTasks;

    public ConfigureProjectWizard(IProject project) {
        this.project = project;
        this.configManager = Activator.getInstance().getConfigManager();
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)Activator.getInstance(), (String)"ConfigureProjectWizard"));
        this.setWindowTitle("Detect and Add Project Natures");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.configPage = new ConfigureProjectWizardPage(this.project);
        this.addPage((IWizardPage)this.configPage);
    }

    void runInit() {
        if (this.allTasks != null) {
            return;
        }
        try {
            final ArrayList<Task> allTasks = new ArrayList<Task>();
            final ArrayList notConfigTasks = new ArrayList();
            final ArrayList<Task> alreadyConfigTasks = new ArrayList<Task>();
            final ArrayList<Task> selectedTasks = new ArrayList<Task>();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ContentFinder contentFinder = new ContentFinder((IContainer)ConfigureProjectWizard.this.project, null, ConfigureProjectWizard.this.configManager, 2, (IProgressMonitor)m.newChild(3));
                        ConfigureProjectWizard.this.project.accept((IResourceVisitor)contentFinder);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        List<AutoConfig> recommendConfigs = contentFinder.getConfigs();
                        ArrayList<AutoConfig> otherConfigs = new ArrayList<AutoConfig>();
                        for (AutoConfig config : ConfigureProjectWizard.this.configManager.getConfigs((byte)2)) {
                            if (recommendConfigs.contains(config)) continue;
                            otherConfigs.add(config);
                        }
                        TaskProcessor.aggregateTasks(ConfigureProjectWizard.this.project, recommendConfigs, 1, selectedTasks, alreadyConfigTasks, notConfigTasks, m.newChild(1));
                        allTasks.addAll(selectedTasks);
                        TaskProcessor.aggregateTasks(ConfigureProjectWizard.this.project, otherConfigs, 0, allTasks, alreadyConfigTasks, notConfigTasks, m.newChild(1));
                        allTasks.addAll(alreadyConfigTasks);
                        notConfigTasks.addAll(alreadyConfigTasks);
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getSeverity() == 8) {
                            throw new InvocationTargetException((Throwable)new OperationCanceledException());
                        }
                        throw new InvocationTargetException(e);
                    }
                }
            });
            this.allTasks = allTasks;
            this.configPage.setInput(allTasks, alreadyConfigTasks, selectedTasks);
        }
        catch (InterruptedException e) {
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                return;
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autonature", 0, "An error occurred when detecting the project configuration proposal.", (Throwable)e), 3);
            return;
        }
    }

    void reset() {
        this.allTasks = null;
        this.configPage.resetInput();
        this.runInit();
    }

    public boolean canFinish() {
        return this.configPage != null && this.configPage.isPageComplete();
    }

    public boolean performFinish() {
        final Collection<Task> configTasks = this.configPage.getConfigTasks();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Configure projects...", (int)1);
                    IJobManager jobManager = Job.getJobManager();
                    IWorkspaceRoot rule = ConfigureProjectWizard.this.project.getWorkspace().getRoot();
                    try {
                        try {
                            jobManager.beginRule((ISchedulingRule)rule, (IProgressMonitor)m);
                            IStatus projectStatus = TaskProcessor.process(ConfigureProjectWizard.this.project, configTasks, m.newChild(1));
                            if (!projectStatus.isOK()) {
                                throw new InvocationTargetException(new CoreException(projectStatus));
                            }
                        }
                        catch (OperationCanceledException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        jobManager.endRule((ISchedulingRule)rule);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            this.reset();
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException || cause instanceof OperationCanceledException) {
                this.reset();
                return false;
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.eutils.autonature", 0, "The project configuration failed for 1 project.", cause), 3);
            return false;
        }
        return true;
    }
}

