/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusLogger;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.status.util.StatusPrinter;

@NonNullByDefault
public class JUtilLoggingStatusLogger
implements StatusLogger {
    private static final Function<String, Logger> CREATE_LOG_FUNCTION = Logger::getLogger;
    private final ConcurrentHashMap<String, Logger> logs = new ConcurrentHashMap();
    private final StatusPrinter logStatusPrinter = new StatusPrinter();

    @Override
    public void log(Status status) {
        Level level;
        Logger log = this.logs.computeIfAbsent(status.getBundleId(), CREATE_LOG_FUNCTION);
        switch (status.getSeverity()) {
            case 4: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.WARNING;
                break;
            }
            default: {
                level = Level.INFO;
            }
        }
        if (log.isLoggable(level)) {
            LogRecord record = new LogRecord(level, this.createMessage(status));
            if (status.getException() != null) {
                record.setThrown(status.getException());
            }
            this.enrichRecord(record, status);
            log.log(record);
        }
    }

    protected String createMessage(Status status) {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder();
        switch (status.getSeverity()) {
            case 0: 
            case 8: {
                sb.append(Statuses.getSeverityString(status.getSeverity()));
                sb.append(' ');
                break;
            }
        }
        sb.append('[');
        sb.append(status.getCode());
        sb.append(']');
        if (status.getMessage().length() <= 80 && status.getMessage().indexOf(10) == -1) {
            sb.append(' ', status.getMessage());
        } else {
            sb.addProp("message", status.getMessage());
        }
        if (status.isMultiStatus()) {
            ImList<Status> children = status.getChildren();
            if (children != null && !children.isEmpty()) {
                StringBuilder sb0 = new StringBuilder();
                sb0.append("Status:\n");
                this.logStatusPrinter.print(children, sb0);
                sb.addProp("children", sb0.toString());
            } else {
                sb.addProp("children", "<none>");
            }
        }
        return sb.toString();
    }

    protected void enrichRecord(LogRecord record, Status status) {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 1;
            while (i < stackTrace.length) {
                if (!stackTrace[i].getMethodName().startsWith("log")) {
                    record.setSourceClassName(stackTrace[i].getClassName());
                    record.setSourceMethodName(stackTrace[i].getMethodName());
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

