/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui.refactoring;

import java.util.Iterator;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

public class ModelElementTester
extends PropertyTester {
    public static final String IS_ELEMENT_SELECTION = "isElementSelection";
    public static final String IS_ELEMENT_C1_TYPE_SELECTION = "isElementC1TypeSelection";
    public static final String IS_ELEMENT_C2_TYPE_SELECTION = "isElementC2TypeSelection";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)receiver;
        int mask = 0;
        if (IS_ELEMENT_C1_TYPE_SELECTION.equals(property)) {
            mask = 3840;
        } else if (IS_ELEMENT_C2_TYPE_SELECTION.equals(property)) {
            mask = 4080;
        }
        int numSu = 1;
        String modelType = (String)expectedValue;
        if (modelType.length() > 0 && modelType.charAt(modelType.length() - 1) == '*') {
            modelType = modelType.substring(0, modelType.length() - 1);
            numSu = -1;
        }
        if (selection.isEmpty()) {
            return false;
        }
        int[] types = this.parseInts(args);
        Iterator iter = selection.iterator();
        boolean first = true;
        SourceUnit su = null;
        block0: while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof LtkModelElement) {
                LtkModelElement element = (LtkModelElement)obj;
                if (numSu == 1) {
                    if (first) {
                        first = false;
                        su = LtkModelUtils.getSourceUnit((LtkModelElement)element);
                        if (su == null) {
                            return false;
                        }
                    } else if (su != LtkModelUtils.getSourceUnit((LtkModelElement)element)) {
                        return false;
                    }
                }
                if (element.getModelTypeId().equals(modelType)) {
                    if (mask == 0) continue;
                    int i = 0;
                    while (i < types.length) {
                        if ((element.getElementType() & mask) == types[i]) continue block0;
                        ++i;
                    }
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private int[] parseInts(Object[] args) {
        int[] ints = new int[args.length];
        int i = 0;
        while (i < args.length) {
            ints[i] = (Integer)args[i];
            ++i;
        }
        return ints;
    }
}

