/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import java.util.List;
import org.eclipse.statet.docmlet.tex.core.ast.TexAstNode;
import org.eclipse.statet.docmlet.tex.core.model.TexElementName;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceElement;
import org.eclipse.statet.internal.docmlet.tex.core.model.BasicLtxSourceElement;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public abstract class ContainerSourceElement
extends BasicLtxSourceElement {
    List<BasicLtxSourceElement> children = NO_CHILDREN;
    TextRegion nameRegion;
    private final TexAstNode astNode;

    public ContainerSourceElement(int type, TexAstNode astNode) {
        super(type);
        this.astNode = astNode;
    }

    public TextRegion getNameSourceRange() {
        return this.nameRegion;
    }

    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    public List<? extends SourceStructElement<?, ?>> getSourceChildren(@Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public abstract @Nullable ContainerSourceElement getModelParent();

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super TexSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.children, filter);
    }

    @Override
    public List<? extends TexSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super TexSourceElement> filter) {
        return LtkModelUtils.getChildren(this.children, filter);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.astNode);
        }
        return super.getAdapter(adapterType);
    }

    public static class SourceContainer
    extends ContainerSourceElement {
        private final SourceUnit sourceUnit;

        public SourceContainer(int type, SourceUnit su, TexAstNode astNode) {
            super(type, astNode);
            this.sourceUnit = su;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        @Override
        public TexElementName getElementName() {
            ElementName elementName = this.sourceUnit.getElementName();
            if (elementName instanceof TexElementName) {
                return (TexElementName)elementName;
            }
            return TexElementName.create(1, elementName.getSegmentName());
        }

        public SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public boolean exists() {
            SourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Ltx", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public @Nullable SourceStructElement<?, ?> getSourceParent() {
            return null;
        }

        @Override
        public @Nullable ContainerSourceElement getModelParent() {
            return null;
        }
    }

    public static class StructContainer
    extends ContainerSourceElement {
        private final ContainerSourceElement parent;

        public StructContainer(int type, ContainerSourceElement parent, TexAstNode astNode) {
            super(type, astNode);
            this.parent = parent;
            this.startOffset = astNode.getStartOffset();
            this.length = astNode.getLength();
        }

        public SourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ContainerSourceElement getSourceParent() {
            return this.parent;
        }

        @Override
        public ContainerSourceElement getModelParent() {
            return this.parent;
        }
    }
}

