/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;
import org.eclipse.statet.r.debug.core.sourcelookup.IRSourceContainer;
import org.eclipse.statet.r.debug.core.sourcelookup.RProjectSourceContainer;

public class AllRProjectsSourceContainer
extends CompositeSourceContainer
implements IRSourceContainer {
    public static final String TYPE_ID = "org.eclipse.statet.r.debugSourceContainers.AllRProjectsType";

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getName() {
        return Messages.AllRProjectsSourceContainer_name;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        IProject[] projects;
        ArrayList<RProjectSourceContainer> list = new ArrayList<RProjectSourceContainer>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.statet.r.resourceProjects.R")) {
                    RProjectSourceContainer container = new RProjectSourceContainer(project, false);
                    container.init(this.getDirector());
                    list.add(container);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return list.toArray(new ISourceContainer[list.size()]);
    }

    @Override
    public Object findSourceElement(URI fileUri, IFile[] fileInWorkspace) throws CoreException {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            IFile element = ((RProjectSourceContainer)containers[i]).findSourceElement(fileUri, fileInWorkspace);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void findSourceElement(IPath path, List<Object> elements) throws CoreException {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            ((RProjectSourceContainer)containers[i]).findSourceElement(path, elements);
            ++i;
        }
    }

    public int hashCode() {
        return this.getClass().hashCode() + 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof AllRProjectsSourceContainer;
    }
}

