/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;

@NonNullByDefault
public class BasicRPkg
implements RPkg {
    private final String name;
    private final RNumVersion version;

    public BasicRPkg(String name, RNumVersion version) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RNumVersion getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.name.hashCode() + this.version.hashCode() * 7;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RPkg) {
            RPkg other = (RPkg)obj;
            return this.name.equals(other.getName()) && this.version.equals(other.getVersion());
        }
        return false;
    }

    public String toString() {
        if (this.version == RNumVersion.NONE) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder(this.name.length() + this.version.toString().length() + 12);
        sb.append(this.name);
        sb.append(" (version= ").append(this.version.toString());
        sb.append(')');
        return sb.toString();
    }
}

