/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

@NonNullByDefault
public final class DocuTag
extends RAstNode {
    private final String name;
    RAstNode[] fragments = NO_CHILDREN;

    DocuTag(String name) {
        this.name = name;
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.DOCU_TAG;
    }

    @Override
    public final @Nullable RTerminal getOperator(int index) {
        return null;
    }

    public final String getText() {
        return this.name;
    }

    @Override
    public final RAstNode[] getChildren() {
        RAstNode[] children = new RAstNode[this.fragments.length];
        System.arraycopy(this.fragments, 0, children, 0, this.fragments.length);
        return children;
    }

    @Override
    public final boolean hasChildren() {
        return this.fragments.length > 0;
    }

    @Override
    public final int getChildCount() {
        return this.fragments.length;
    }

    @Override
    public final RAstNode getChild(int index) {
        return this.fragments[index];
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = 0;
        while (i < this.fragments.length) {
            if (this.fragments[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        int i = 0;
        while (i < this.fragments.length) {
            this.fragments[i].acceptInR(visitor);
            ++i;
        }
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        int i = 0;
        while (i < this.fragments.length) {
            visitor.visit((AstNode)this.fragments[i]);
            ++i;
        }
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        if (NodeType.DOCU_TAG == element.getNodeType()) {
            DocuTag other = (DocuTag)element;
            return Objects.equals(this.name, other.name);
        }
        return false;
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
    }
}

