/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.util.Objects;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.rsource.ast.Expression;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAstVisitor;

@NonNullByDefault
abstract class SingleValue
extends RAstNode {
    @Nullable String text;

    protected SingleValue() {
    }

    public final @Nullable String getText() {
        return this.text;
    }

    abstract void setText(@Nullable String var1, @Nullable TextRegion var2);

    @Override
    public final boolean hasChildren() {
        return false;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final RAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final RAstNode[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public final int getChildIndex(AstNode child) {
        return -1;
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) {
    }

    public final void acceptInChildren(AstVisitor visitor) {
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public boolean equalsValue(RAstNode element) {
        if (this.getNodeType() == element.getNodeType()) {
            SingleValue other = (SingleValue)element;
            return Objects.equals(this.text, other.text);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(super.toString());
        String text = this.text;
        if (text != null) {
            s.append(" \u25ca ");
            this.appendEscaped(s, text);
        }
        return s.toString();
    }

    void appendEscaped(StringBuilder builder, CharSequence text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        throw new IllegalArgumentException();
    }
}

