/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.graphics.core;

public class ColorDef {
    protected int fRed;
    protected int fGreen;
    protected int fBlue;

    public static final ColorDef parseRGBHex(String s) {
        try {
            return new ColorDef(Integer.parseInt(s.substring(0, 2), 16), Integer.parseInt(s.substring(2, 4), 16), Integer.parseInt(s.substring(4, 6), 16));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected ColorDef() {
    }

    public ColorDef(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("red");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("green");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("blue");
        }
        this.fRed = red;
        this.fGreen = green;
        this.fBlue = blue;
    }

    public ColorDef(ColorDef def) {
        this.fRed = def.fRed;
        this.fGreen = def.fGreen;
        this.fBlue = def.fBlue;
    }

    public String getType() {
        return "rgb";
    }

    public final int getRed() {
        return this.fRed;
    }

    public final int getGreen() {
        return this.fGreen;
    }

    public final int getBlue() {
        return this.fBlue;
    }

    public int hashCode() {
        return this.fRed << 16 | this.fGreen << 8 | this.fBlue;
    }

    public boolean equals(Object obj) {
        return obj instanceof ColorDef && this.equalsRGB((ColorDef)obj);
    }

    public final boolean equalsRGB(ColorDef other) {
        return other != null && this.fRed == other.fRed && this.fGreen == other.fGreen && this.fBlue == other.fBlue;
    }

    public final void printRGBHex(StringBuilder sb) {
        if (this.fRed < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.fRed));
        if (this.fGreen < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.fGreen));
        if (this.fBlue < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(this.fBlue));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(7);
        sb.append('#');
        this.printRGBHex(sb);
        return sb.toString();
    }
}

