/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.eclipse.statet.internal.rhelp.core.DataStream;
import org.eclipse.statet.internal.rhelp.core.REnvHelpImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpCoreInternals;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordGroupImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpKeywordImpl;
import org.eclipse.statet.internal.rhelp.core.RHelpPageImpl;
import org.eclipse.statet.internal.rhelp.core.RPkgHelpImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rhelp.core.DocResource;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.RHelpKeyword;
import org.eclipse.statet.rhelp.core.RHelpKeywordGroup;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.BasicRPkgDescription;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkgDescription;

@NonNullByDefault
public class SerUtil {
    public static final int VERSION_12 = 12;
    public static final int VERSION_11 = 11;
    public static final int VERSION_10 = 10;
    public static final int CURRENT_VERSION = 12;
    public static final int[] KNOWN_VERSIONS = new int[]{12, 11, 10};
    private static final int COMPRESS = 16;
    private static final String RHELP_SER_FILE = "rhelp.ser";

    public static @Nullable Path getIndexDirectoryPath(REnvHelpConfiguration rEnvConfig) {
        try {
            Path stateDirectory = rEnvConfig.getStateSharedDirectoryPath();
            if (stateDirectory != null) {
                return stateDirectory.resolve("index");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Path getIndexDirectoryChecked(REnvHelpConfiguration rEnvConfig) {
        Exception e1 = null;
        try {
            Path stateDirectory = rEnvConfig.getStateSharedDirectoryPath();
            if (stateDirectory != null) {
                Path indexDirectory = stateDirectory.resolve("index");
                if (!Files.isDirectory(indexDirectory, new LinkOption[0])) {
                    Files.createDirectories(indexDirectory, new FileAttribute[0]);
                }
                return indexDirectory;
            }
        }
        catch (Exception e) {
            e1 = e;
        }
        throw new RuntimeException(String.format("Index directory could not be resolved: '%1$s'.", rEnvConfig.getStateSharedDirectory()), e1);
    }

    public static Path getBasicDataFilePath(Path indexDirectory) {
        return indexDirectory.resolve(RHELP_SER_FILE);
    }

    public static @Nullable Path getBasicDataFilePath(REnvHelpConfiguration rEnvConfig) {
        Path directory = SerUtil.getIndexDirectoryPath(rEnvConfig);
        if (directory != null) {
            return SerUtil.getBasicDataFilePath(directory);
        }
        return null;
    }

    public boolean canRead(int version, String type) {
        switch (version) {
            case 11: 
            case 12: {
                return true;
            }
            case 10: {
                return type == "server";
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(REnvHelpConfiguration rEnvConfig, REnvHelpImpl help, Controller controller) {
        try {
            Path directory = SerUtil.getIndexDirectoryChecked(rEnvConfig);
            Path newFile = directory.resolve("rhelp.ser.new");
            Files.deleteIfExists(newFile);
            Object object = null;
            Object var7_9 = null;
            try (DataStream out = DataStream.get(new BufferedOutputStream(Files.newOutputStream(newFile, StandardOpenOption.CREATE_NEW)));){
                this.save(help, out, 16);
                out.flush();
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
            object = controller.getFileLock();
            synchronized (object) {
                if (!controller.shouldSave()) {
                    return false;
                }
                Path serFile = directory.resolve(RHELP_SER_FILE);
                Files.move(newFile, serFile, StandardCopyOption.REPLACE_EXISTING);
                controller.onSaved();
                return true;
            }
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when saving R help data for '%1$s'.", rEnvConfig.getName()), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(REnvHelpConfiguration rEnvConfig, InputStream in, Controller controller) {
        try {
            Path directory = SerUtil.getIndexDirectoryChecked(rEnvConfig);
            Path newFile = directory.resolve("rhelp.ser.new");
            Files.deleteIfExists(newFile);
            Object object = null;
            Object var7_9 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(newFile, StandardOpenOption.CREATE_NEW));){
                DataStream.copy(in, out);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
            object = controller.getFileLock();
            synchronized (object) {
                if (!controller.shouldSave()) {
                    return false;
                }
                Path serFile = directory.resolve(RHELP_SER_FILE);
                Files.move(newFile, serFile, StandardCopyOption.REPLACE_EXISTING);
                controller.onSaved();
                return true;
            }
        }
        catch (Exception e) {
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when saving R help data for '%1$s'.", rEnvConfig.getName()), (Throwable)e));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStamp(REnvHelpConfiguration rEnvConfig) {
        try {
            Path serFile = SerUtil.getBasicDataFilePath(rEnvConfig);
            if (!Files.isRegularFile(serFile, new LinkOption[0])) {
                return 0L;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (DataStream in = DataStream.get(new BufferedInputStream(Files.newInputStream(serFile, new OpenOption[0]), 64));){
                int version = in.readVersion();
                if (version == 12) return in.readLong();
                if (this.canRead(version, rEnvConfig.getStateSharedType())) return in.readLong();
                return 0L;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable e) {
            if (e instanceof Error && !(e instanceof UnsupportedVersionException)) {
                throw (Error)e;
            }
            RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when loading R help data for '%1$s'.", rEnvConfig.getName()), e));
            return 0L;
        }
    }

    public @Nullable REnvHelpImpl load(REnvHelpConfiguration rEnvConfig) {
        Path serFile;
        block13: {
            try {
                serFile = SerUtil.getBasicDataFilePath(rEnvConfig);
                if (Files.isRegularFile(serFile, new LinkOption[0])) break block13;
                return null;
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                RHelpCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.core", String.format("An error occurred when loading R help data for '%1$s'.", rEnvConfig.getName()), e));
                return null;
            }
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (DataStream in = DataStream.get(new BufferedInputStream(Files.newInputStream(serFile, new OpenOption[0])));){
            return this.load(rEnvConfig, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void save(REnvHelpImpl help, DataStream out, int flags) throws IOException {
        out.writeVersion(12);
        out.writeLong(help.getStamp());
        out.writeInt(flags);
        if ((flags & 0x10) != 0) {
            out.enableCompression();
        }
        out.writeString(help.getDocDir());
        ImList<DocResource> resources = help.getManuals();
        int count = resources.size();
        out.writeInt(count);
        int i = 0;
        while (i < count) {
            this.saveDocResource((DocResource)resources.get(i), out);
            ++i;
        }
        resources = help.getMiscResources();
        count = resources.size();
        out.writeInt(count);
        i = 0;
        while (i < count) {
            this.saveDocResource((DocResource)resources.get(i), out);
            ++i;
        }
        ImList<RHelpKeywordGroup> keywordGroups = help.getKeywords();
        count = keywordGroups.size();
        out.writeInt(count);
        i = 0;
        while (i < keywordGroups.size()) {
            this.saveKeywordGroup((RHelpKeywordGroup)keywordGroups.get(i), out);
            ++i;
        }
        ImList<RPkgHelp> packages = help.getPkgs();
        count = packages.size();
        out.writeInt(count);
        i = 0;
        while (i < packages.size()) {
            this.savePackage((RPkgHelp)packages.get(i), out);
            ++i;
        }
    }

    public REnvHelpImpl load(REnvHelpConfiguration rEnvConfig, DataStream in) throws IOException {
        int version = in.readVersion();
        if (version != 12 && !this.canRead(version, rEnvConfig.getStateSharedType())) {
            throw new UnsupportedVersionException(version);
        }
        long stamp = in.readLong();
        int flags = in.readInt();
        if ((flags & 0x10) != 0) {
            in.enableCompression();
        }
        String docDir = in.readString();
        int count = in.readInt();
        Object[] array = new DocResource[count];
        int i = 0;
        while (i < count) {
            array[i] = this.readDocResource(in);
            ++i;
        }
        ImList manuals = ImCollections.newList((Object[])array);
        int count2 = in.readInt();
        Object[] array2 = new DocResource[count2];
        int i2 = 0;
        while (i2 < count2) {
            array2[i2] = this.readDocResource(in);
            ++i2;
        }
        ImList miscRes = ImCollections.newList((Object[])array2);
        int count3 = in.readInt();
        Object[] array3 = new RHelpKeywordGroup[count3];
        int i3 = 0;
        while (i3 < count3) {
            array3[i3] = this.loadKeywordGroup(in);
            ++i3;
        }
        ImList keywordGroups = ImCollections.newList((Object[])array3);
        int count4 = in.readInt();
        Object[] array4 = new RPkgHelp[count4];
        int i4 = 0;
        while (i4 < count4) {
            array4[i4] = this.loadPackage(rEnvConfig, in);
            ++i4;
        }
        ImList pkgHelps = ImCollections.newList((Object[])array4);
        return new REnvHelpImpl(rEnvConfig.getREnv(), version, stamp, docDir, (ImList<DocResource>)manuals, (ImList<DocResource>)miscRes, (ImList<RHelpKeywordGroup>)keywordGroups, (ImList<RPkgHelp>)pkgHelps);
    }

    private void saveDocResource(DocResource res, DataStream out) throws IOException {
        out.writeString(res.getTitle());
        out.writeString(res.getPath());
        out.writeString(res.getPdfPath());
    }

    private DocResource readDocResource(DataStream in) throws IOException {
        return new DocResource(in.readNonNullString(), in.readNonNullString(), in.readString());
    }

    private void saveKeywordGroup(RHelpKeywordGroup group, DataStream out) throws IOException {
        out.writeString(group.getLabel());
        out.writeString(group.getDescription());
        List<RHelpKeyword> keywords = group.getNestedKeywords();
        int count = keywords.size();
        out.writeInt(count);
        int i = 0;
        while (i < count) {
            this.saveKeyword(keywords.get(i), out);
            ++i;
        }
    }

    private RHelpKeywordGroup loadKeywordGroup(DataStream in) throws IOException {
        String label = in.readString();
        String description = in.readString();
        int count = in.readInt();
        Object[] keywords = new RHelpKeyword[count];
        int i = 0;
        while (i < count) {
            keywords[i] = this.loadKeyword(in);
            ++i;
        }
        return new RHelpKeywordGroupImpl(label, description, (ImList<RHelpKeyword>)ImCollections.newList((Object[])keywords));
    }

    private void saveKeyword(RHelpKeyword keyword, DataStream out) throws IOException {
        out.writeString(keyword.getKeyword());
        out.writeString(keyword.getDescription());
        List<RHelpKeyword> nestedKeywords = keyword.getNestedKeywords();
        int count = nestedKeywords.size();
        out.writeInt(count);
        int i = 0;
        while (i < nestedKeywords.size()) {
            this.saveKeyword(nestedKeywords.get(i), out);
            ++i;
        }
    }

    private RHelpKeyword loadKeyword(DataStream in) throws IOException {
        String keyword = in.readString();
        String description = in.readString();
        int n = in.readInt();
        Object[] nestedKeywords = new RHelpKeyword[n];
        int i = 0;
        while (i < n) {
            nestedKeywords[i] = this.loadKeyword(in);
            ++i;
        }
        return new RHelpKeywordImpl(keyword, description, (ImList<RHelpKeyword>)ImCollections.newList((Object[])nestedKeywords));
    }

    private void savePackage(RPkgHelp pkgHelp, DataStream out) throws IOException {
        this.savePkgDescription(pkgHelp.getPkgDescription(), out);
        ImList<RHelpPage> pages = pkgHelp.getPages();
        int nPages = pages.size();
        out.writeInt(nPages);
        int i = 0;
        while (i < nPages) {
            this.savePage((RHelpPage)pages.get(i), out);
            ++i;
        }
    }

    private RPkgHelp loadPackage(REnvHelpConfiguration rEnvConfig, DataStream in) throws IOException {
        RPkgDescription pkgDescription = this.loadPkgDescription(rEnvConfig, in);
        int nPages = in.readInt();
        Object[] pages = new RHelpPage[nPages];
        RPkgHelpImpl pkg = new RPkgHelpImpl(pkgDescription, rEnvConfig.getREnv());
        int i = 0;
        while (i < nPages) {
            pages[i] = this.loadPage(pkg, in);
            ++i;
        }
        pkg.setPages((ImList<RHelpPage>)ImCollections.newList((Object[])pages));
        return pkg;
    }

    private void savePkgDescription(RPkgDescription pkgDescription, DataStream out) throws IOException {
        out.writeString(pkgDescription.getName());
        out.writeString(pkgDescription.getVersion().toString());
        out.writeString(pkgDescription.getTitle());
        out.writeString(pkgDescription.getDescription());
        out.writeString(pkgDescription.getAuthor());
        out.writeString(pkgDescription.getMaintainer());
        out.writeString(pkgDescription.getUrl());
        out.writeString(pkgDescription.getBuilt());
        out.writeString(pkgDescription.getLibLocation().getDirectory());
    }

    private RPkgDescription loadPkgDescription(REnvHelpConfiguration rEnvConfig, DataStream in) throws IOException {
        String name = in.readNonNullString().intern();
        String version = in.readNonNullString();
        String title = in.readNonNullString();
        String description = in.readNonNullString();
        String author = in.readString();
        String maintainer = in.readString();
        String url = in.readString();
        String built = in.readNonNullString();
        RLibLocation libLocation = this.getLibLocationSafe(rEnvConfig, in.readNonNullString());
        return new BasicRPkgDescription(name, RNumVersion.create((String)version), title, description, author, maintainer, url, built, libLocation);
    }

    private RLibLocation getLibLocationSafe(REnvHelpConfiguration rEnvConfig, String directory) {
        RLibLocation libLocation = rEnvConfig.getRLibLocationByDirectory(directory);
        if (libLocation == null) {
            libLocation = new BasicRLibLocation("missing", directory, null);
        }
        return libLocation;
    }

    private void savePage(RHelpPage page, DataStream out) throws IOException {
        if (out.getVersion() >= 12) {
            out.writeByte(RHelpPageImpl.createFlags(page.isInternal()));
        }
        out.writeString(page.getName());
        ImList<String> topics = page.getTopics();
        int nTopics = topics.size();
        out.writeInt(nTopics);
        int i = 0;
        while (i < nTopics) {
            String topic = (String)topics.get(i);
            out.writeString(topic == page.getName() ? null : topic);
            ++i;
        }
        out.writeString(page.getTitle());
    }

    private RHelpPage loadPage(RPkgHelp pkg, DataStream in) throws IOException {
        byte pageFlags = in.getVersion() >= 12 ? in.readByte() : (byte)0;
        String name = in.readNonNullString().intern();
        int nTopics = in.readInt();
        Object[] array = new String[nTopics];
        int i = 0;
        while (i < array.length) {
            String topic = in.readString();
            array[i] = topic == null ? name : topic.intern();
            ++i;
        }
        ImList topics = ImCollections.newList((Object[])array);
        String title = in.readNonNullString();
        return new RHelpPageImpl(pkg, name, pageFlags, (ImList<String>)topics, title);
    }

    public static interface Controller {
        public Object getFileLock();

        public boolean shouldSave();

        public void onSaved();
    }

    private static class UnsupportedVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public UnsupportedVersionException(int inputVersion) {
            super("input= " + inputVersion);
        }
    }
}

