/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.jetty;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.server.ResourceContentFactory;
import org.eclipse.jetty.server.ResourceService;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ResourceHandler;

@NonNullByDefault
public class JettyResourceHandler
extends ResourceService
implements ResourceHandler,
ResourceFactory {
    private final JettyMimeTypes mediaTypes;

    public JettyResourceHandler(MediaTypeProvider defaultTypes) {
        this.mediaTypes = new JettyMimeTypes(defaultTypes);
        this.setContentFactory((HttpContent.ContentFactory)new ResourceContentFactory((ResourceFactory)this, (MimeTypes)this.mediaTypes, new CompressedContentFormat[0]));
    }

    @Override
    public void setSpecialMediaTypes(MediaTypeProvider types) {
        this.mediaTypes.specialMediaTypes = types;
    }

    @Override
    public void setCacheControl(String value) {
        this.setCacheControl((HttpField)new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, value));
    }

    public Resource getResource(String path) {
        return new PathResource(Paths.get(path, new String[0]));
    }

    @Override
    public void doGet(Path path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpContent content = this.getContentFactory().getContent(path.toString(), resp.getBufferSize());
        boolean releaseContent = true;
        try {
            if (content == null || !content.getResource().exists()) {
                this.notFound(req, resp);
                return;
            }
            if (content.getResource().isDirectory()) {
                resp.sendError(400);
            }
            if (!this.passConditionalHeaders(req, resp, content)) {
                return;
            }
            Enumeration reqRanges = req.getHeaders(HttpHeader.RANGE.asString());
            if (reqRanges != null && !reqRanges.hasMoreElements()) {
                reqRanges = null;
            }
            releaseContent = this.sendData(req, resp, false, content, reqRanges);
        }
        finally {
            if (releaseContent && content != null) {
                content.release();
            }
        }
    }

    private static class JettyMimeTypes
    extends MimeTypes {
        private final MediaTypeProvider defaultMediaTypes;
        private @Nullable MediaTypeProvider specialMediaTypes;

        public JettyMimeTypes(MediaTypeProvider mimeTypes) {
            this.defaultMediaTypes = mimeTypes;
        }

        public @Nullable String getMimeByExtension(String filename) {
            int idx = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (idx >= 0) {
                filename = filename.substring(idx + 1);
            }
            String type = null;
            if (this.specialMediaTypes != null) {
                type = this.specialMediaTypes.getMediaTypeString(filename);
            }
            if (type == null) {
                type = this.defaultMediaTypes.getMediaTypeString(filename);
            }
            if (type == null) {
                type = super.getMimeByExtension(filename);
            }
            return type;
        }
    }
}

