/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.action;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommand;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LayerUtil;
import org.eclipse.statet.ecommons.waltable.painter.cell.ColumnHeaderCheckBoxPainter;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.swt.events.MouseEvent;

public class ToggleCheckBoxColumnAction
implements IMouseAction {
    private final ColumnHeaderCheckBoxPainter columnHeaderCheckBoxPainter;
    private final ILayer bodyDataLayer;

    public ToggleCheckBoxColumnAction(ColumnHeaderCheckBoxPainter columnHeaderCheckBoxPainter, ILayer bodyDataLayer) {
        this.columnHeaderCheckBoxPainter = columnHeaderCheckBoxPainter;
        this.bodyDataLayer = bodyDataLayer;
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        long sourceColumnPosition = natTable.getColumnPositionByX(event.x);
        long columnPosition = LayerUtil.convertColumnPosition(natTable, sourceColumnPosition, this.bodyDataLayer);
        long checkedCellsCount = this.columnHeaderCheckBoxPainter.getCheckedCellsCount(columnPosition, natTable.getConfigRegistry());
        boolean targetState = checkedCellsCount < this.bodyDataLayer.getRowCount();
        long rowPosition = 0L;
        while (rowPosition < this.bodyDataLayer.getRowCount()) {
            this.bodyDataLayer.doCommand(new UpdateDataCommand(this.bodyDataLayer, columnPosition, rowPosition, targetState));
            ++rowPosition;
        }
    }
}

