/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.NoOpDocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlinesSubstitution;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class InlineParser {
    private static final CommonmarkLocator NO_OP_LOCATOR = new CommonmarkLocator();
    private final ImList<SourceSpan> spans;

    public static void emit(ProcessingContext context, List<Inline> inlines, CommonmarkLocator locator, DocumentBuilder builder) {
        for (Inline inline : inlines) {
            locator.setInline(inline);
            inline.emit(context, locator, builder);
        }
    }

    public static String toStringContent(final ProcessingContext context, List<Inline> contents) {
        final StringBuilder stringBuilder = new StringBuilder();
        NoOpDocumentBuilder altDocumentBuilder = new NoOpDocumentBuilder(){

            public void characters(String text) {
                stringBuilder.append(text);
            }

            public void entityReference(String entity) {
                String replacement = context.getHelper().resolveHtmlEntity(entity);
                if (replacement != null) {
                    stringBuilder.append(replacement);
                }
            }
        };
        for (Inline inline : contents) {
            inline.emit(context, NO_OP_LOCATOR, (DocumentBuilder)altDocumentBuilder);
        }
        return stringBuilder.toString();
    }

    public InlineParser(ImList<SourceSpan> spans) {
        this.spans = ImCollections.toList(spans);
    }

    public void emit(ProcessingContext context, TextSegment textSegment, CommonmarkLocator locator, DocumentBuilder builder) {
        List<Inline> inlines = this.parse(context, textSegment, false);
        InlineParser.emit(context, inlines, locator, builder);
    }

    public String toStringContent(ProcessingContext context, TextSegment textSegment) {
        List<Inline> inlines = this.parse(context, textSegment, false);
        return InlineParser.toStringContent(context, inlines);
    }

    public List<Inline> parse(ProcessingContext context, TextSegment segment, boolean inBlock) {
        Cursor cursor = new Cursor(segment);
        ArrayList<Inline> inlines = new ArrayList<Inline>();
        block0: while (cursor.hasChar()) {
            for (SourceSpan span : this.spans) {
                Inline inline = span.createInline(context, cursor);
                if (inline == null) continue;
                inline.apply(context, inlines, cursor, inBlock);
                continue block0;
            }
            throw new IllegalStateException();
        }
        return InlineParser.secondPass(inlines);
    }

    static List<Inline> secondPass(List<Inline> inlines) {
        List<Inline> processedInlines = new ArrayList<Inline>(inlines);
        InlinesSubstitution substitution = null;
        block0: do {
            for (Inline inline : processedInlines) {
                substitution = inline.secondPass(processedInlines);
                if (substitution == null) continue;
                processedInlines = substitution.apply(processedInlines);
                continue block0;
            }
        } while (substitution != null);
        return processedInlines;
    }
}

