/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv;

import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public abstract class ServerControl {
    public static final int EXIT_ARGS = 130;
    public static final int EXIT_INIT = 140;
    public static final int EXIT_INIT_LOGGING_ERROR = 141;
    public static final int EXIT_INIT_AUTHMETHOD_ERROR = 143;
    public static final int EXIT_INIT_RENGINE_ERROR = 141;
    private static boolean VERBOSE = false;
    private static boolean VERBOSE_ON_ERROR = true;
    protected static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server.srv");
    private final Map<String, String> options;

    public static void initVerbose() {
        if (VERBOSE) {
            return;
        }
        VERBOSE = true;
        LOGGER.setLevel(Level.ALL);
        ClassLoader.getSystemClassLoader().setDefaultAssertionStatus(true);
        Logger logger = LOGGER;
        block0: while (logger != null) {
            Handler[] handlerArray = logger.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler instanceof ConsoleHandler) {
                    handler.setLevel(Level.ALL);
                    break block0;
                }
                ++n2;
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
        StringBuilder sb = new StringBuilder(256);
        LOGGER.log(Level.CONFIG, "verbose mode enabled.");
        sb.setLength(0);
        sb.append("java properties:");
        ServerUtils.prettyPrint(System.getProperties(), sb);
        LOGGER.log(Level.CONFIG, sb.toString());
        sb.setLength(0);
        sb.append("env variables:");
        ServerUtils.prettyPrint(System.getenv(), sb);
        LOGGER.log(Level.CONFIG, sb.toString());
    }

    public static void exit(int status) {
        try {
            if (status != 0 && VERBOSE_ON_ERROR) {
                ServerControl.initVerbose();
            }
            System.err.flush();
            System.out.flush();
        }
        finally {
            Runtime.getRuntime().exit(status);
        }
    }

    public ServerControl(Map<String, String> options) {
        this.options = options;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

