/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.selection.SelectCellCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class SelectCellCommandHandler
extends AbstractLayerCommandHandler<SelectCellCommand> {
    private final SelectionLayer selectionLayer;

    public SelectCellCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<SelectCellCommand> getCommandClass() {
        return SelectCellCommand.class;
    }

    @Override
    protected boolean doCommand(SelectCellCommand command) {
        this.toggleOrSelectCell(command.getColumnPosition(), command.getRowPosition(), command.getSelectionFlags());
        this.selectionLayer.fireCellSelectionEvent(command.getColumnPosition(), command.getRowPosition(), command.getRevealCell());
        return true;
    }

    protected void toggleOrSelectCell(long columnPosition, long rowPosition, int selectionFlags) {
        if ((selectionFlags & 0x60000) == 262144 && this.selectionLayer.isCellPositionSelected(columnPosition, rowPosition)) {
            this.selectionLayer.clearSelection(columnPosition, rowPosition);
            return;
        }
        this.selectCell(columnPosition, rowPosition, selectionFlags);
    }

    protected void selectCell(long columnPosition, long rowPosition, int selectionFlags) {
        if ((selectionFlags & 0x60000) == 0) {
            this.selectionLayer.clearSelections();
        }
        this.selectionLayer.lastSelectedCell.columnPosition = columnPosition;
        this.selectionLayer.lastSelectedCell.rowPosition = rowPosition;
        if (this.selectionLayer.getSelectionModel().isMultipleSelectionAllowed() && (selectionFlags & 0x20000) != 0 && this.selectionLayer.lastSelectedRegion != null && this.selectionLayer.selectionAnchor.columnPosition >= 0L) {
            if ((selectionFlags & 0x40000) != 0) {
                this.selectionLayer.lastSelectedRegion = new LRectangle(0L, 0L, 0L, 0L);
            }
            this.selectionLayer.lastSelectedRegion.x = Math.min(this.selectionLayer.selectionAnchor.columnPosition, columnPosition);
            this.selectionLayer.lastSelectedRegion.width = Math.abs(this.selectionLayer.selectionAnchor.columnPosition - columnPosition) + 1L;
            this.selectionLayer.lastSelectedRegion.y = Math.min(this.selectionLayer.selectionAnchor.rowPosition, rowPosition);
            this.selectionLayer.lastSelectedRegion.height = Math.abs(this.selectionLayer.selectionAnchor.rowPosition - rowPosition) + 1L;
            this.selectionLayer.addSelection(this.selectionLayer.lastSelectedRegion);
        } else {
            this.selectionLayer.addSelection(new LRectangle(columnPosition, rowPosition, 1L, 1L));
        }
    }
}

