/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

@Deprecated
public class BoostingQuery
extends Query {
    private final float contextBoost;
    private final Query match;
    private final Query context;

    public BoostingQuery(Query match, Query context, float boost) {
        this.match = match;
        this.context = context;
        this.contextBoost = boost;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query matchRewritten = this.match.rewrite(reader);
        Query contextRewritten = this.context.rewrite(reader);
        if (this.match != matchRewritten || this.context != contextRewritten) {
            return new BoostingQuery(matchRewritten, contextRewritten, this.contextBoost);
        }
        return super.rewrite(reader);
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores, final float boost) throws IOException {
        if (!needsScores) {
            return this.match.createWeight(searcher, needsScores, boost);
        }
        final Weight matchWeight = searcher.createWeight(this.match, needsScores, boost);
        final Weight contextWeight = searcher.createWeight(this.context, false, boost);
        return new Weight(this){

            public void extractTerms(Set<Term> terms) {
                matchWeight.extractTerms(terms);
                if (boost >= 1.0f) {
                    contextWeight.extractTerms(terms);
                }
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                Explanation matchExplanation = matchWeight.explain(context, doc);
                Explanation contextExplanation = contextWeight.explain(context, doc);
                if (!matchExplanation.isMatch() || !contextExplanation.isMatch()) {
                    return matchExplanation;
                }
                return Explanation.match((float)(matchExplanation.getValue() * BoostingQuery.this.contextBoost), (String)"product of:", (Explanation[])new Explanation[]{matchExplanation, Explanation.match((float)BoostingQuery.this.contextBoost, (String)"boost", (Explanation[])new Explanation[0])});
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer matchScorer = matchWeight.scorer(context);
                if (matchScorer == null) {
                    return null;
                }
                Scorer contextScorer = contextWeight.scorer(context);
                if (contextScorer == null) {
                    return matchScorer;
                }
                final TwoPhaseIterator contextTwoPhase = contextScorer.twoPhaseIterator();
                final DocIdSetIterator contextApproximation = contextTwoPhase == null ? contextScorer.iterator() : contextTwoPhase.approximation();
                return new FilterScorer(matchScorer){

                    public float score() throws IOException {
                        if (contextApproximation.docID() < this.docID()) {
                            contextApproximation.advance(this.docID());
                        }
                        assert (contextApproximation.docID() >= this.docID());
                        float score = super.score();
                        if (contextApproximation.docID() == this.docID() && (contextTwoPhase == null || contextTwoPhase.matches())) {
                            score *= BoostingQuery.this.contextBoost;
                        }
                        return score;
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return matchWeight.isCacheable(ctx) && contextWeight.isCacheable(ctx);
            }
        };
    }

    public Query getMatch() {
        return this.match;
    }

    public Query getContext() {
        return this.context;
    }

    public float getBoost() {
        return this.contextBoost;
    }

    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.match, this.context, Float.valueOf(this.contextBoost));
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((BoostingQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(BoostingQuery other) {
        return this.match.equals((Object)other.match) && this.context.equals((Object)other.context) && Float.floatToIntBits(this.contextBoost) == Float.floatToIntBits(other.contextBoost);
    }

    public String toString(String field) {
        return this.match.toString(field) + "/" + this.context.toString(field);
    }
}

