/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.LabelInfo;
import org.eclipse.statet.docmlet.wikitext.core.source.LinkByRefAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ToStringHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineWithNestedContents;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class Link
extends InlineWithNestedContents {
    private final String href;
    private final @Nullable LabelInfo labelReference;
    private final @Nullable String title;

    public Link(Line line, int offset, int length, int cursorLength, String href, @Nullable String title, List<? extends Inline> contents) {
        super(line, offset, length, cursorLength, contents);
        this.href = (String)ObjectUtils.nonNullAssert((Object)href);
        this.labelReference = null;
        this.title = title;
    }

    public Link(Line line, int offset, int length, String href, @Nullable String title, List<Inline> contents) {
        this(line, offset, length, -1, href, title, contents);
    }

    public Link(Line line, int offset, int length, LabelInfo labelReference, List<Inline> contents) {
        super(line, offset, length, -1, contents);
        this.href = "ref:" + labelReference.getLabel();
        this.labelReference = labelReference;
        this.title = null;
    }

    public String getHref() {
        return this.href;
    }

    @Override
    public void emit(ProcessingContext context, CommonmarkLocator locator, DocumentBuilder builder) {
        LinkByRefAttributes attributes = this.labelReference != null ? new LinkByRefAttributes(this.labelReference) : new LinkAttributes();
        attributes.setTitle(this.title);
        attributes.setHref(this.href);
        builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        InlineParser.emit(context, this.getContents(), locator, builder);
        builder.endSpan();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), this.getContents(), this.href, this.title);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            Link other = (Link)obj;
            return this.href.equals(other.href) && this.getContents().equals(other.getContents()) && Objects.equals(this.title, other.title);
        }
        return false;
    }

    @Override
    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(Link.class, this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        sb.addProp("href", ToStringHelper.toStringValue(this.href));
        sb.addProp("title", this.title);
        sb.addProp("contents", this.getContents());
        return sb.build();
    }
}

