/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.commands;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.statet.docmlet.tex.core.commands.Argument;
import org.eclipse.statet.docmlet.tex.core.commands.TexPackage;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TexCommand
implements Comparable<TexCommand> {
    public static final int MASK_MAIN = 15;
    public static final int MASK_C2 = 255;
    public static final int MASK_C3 = 4095;
    public static final int GENERICENV = 1;
    public static final int C2_GENERICENV_BEGIN = 17;
    public static final int C2_GENERICENV_END = 33;
    public static final int ENV = 2;
    public static final int C2_ENV_MATH_BEGIN = 18;
    public static final int C3_ENV_MATH_INLINE_BEGIN = 274;
    public static final int C3_ENV_MATH_DISPLAY_BEGIN = 530;
    public static final int C2_ENV_DOCUMENT_BEGIN = 34;
    public static final int C2_ENV_VERBATIM_BEGIN = 50;
    public static final int C2_ENV_COMMENT_BEGIN = 66;
    public static final int C2_ENV_ELEMENT_BEGIN = 114;
    public static final int C3_ENV_ELEMENT_QUOTE_BEGIN = 370;
    public static final int C3_ENV_ELEMENT_LISTS_BEGIN = 882;
    public static final int C3_ENV_ELEMENT_TABLES_BEGIN = 1138;
    public static final int C3_ENV_ELEMENT_GRAPHICS_BEGIN = 1394;
    public static final int C3_ENV_ELEMENT_FLOATS_BEGIN = 1906;
    public static final int C3_ENV_ELEMENT_ALIGN_BEGIN = 2162;
    public static final int C2_ENV_MATHCONTENT_BEGIN = 130;
    public static final int C2_ENV_OTHER_BEGIN = 242;
    public static final int VERBATIM_INLINE = 3;
    public static final int PREAMBLE = 4;
    public static final int C2_PREAMBLE_DOCDEF = 20;
    public static final int C2_PREAMBLE_PACKAGE = 36;
    public static final int C2_PREAMBLE_CONTROLDEF = 52;
    public static final int C3_PREAMBLE_CONTROLDEF_COMMAND = 308;
    public static final int C3_PREAMBLE_CONTROLDEF_ENV = 564;
    public static final int C2_PREAMBLE_MISC = 100;
    public static final int DOCUMENT = 5;
    public static final int C2_DOCUMENT_INCLUDE = 21;
    public static final int C2_DOCUMENT_ELEMENT = 37;
    public static final int C3_DOCUMENT_ELEMENT_LISTS = 805;
    public static final int C3_DOCUMENT_ELEMENT_TABLES = 1061;
    public static final int C3_DOCUMENT_ELEMENT_IMAGES = 1317;
    public static final int C2_DOCUMENT_CONTENTLISTS = 53;
    public static final int C3_DOCUMENT_CONTENTLISTS_DEF = 309;
    public static final int C3_DOCUMENT_CONTENTLISTS_GEN = 821;
    public static final int C2_DOCUMENT_INDEX = 69;
    public static final int C3_DOCUMENT_INDEX_DEF = 325;
    public static final int C3_DOCUMENT_INDEX_GEN = 837;
    public static final int C2_DOCUMENT_LAYOUT = 117;
    public static final int SECTIONING = 6;
    public static final int PART_LEVEL = 1;
    public static final int CHAPTER_LEVEL = 2;
    public static final int SECTION_LEVEL = 3;
    public static final int SUBSECTION_LEVEL = 4;
    public static final int SUBSUBSECTION_LEVEL = 5;
    public static final int C2_SECTIONING_PART = 22;
    public static final int C3_SECTIONING_PART_APPENDIX = 534;
    public static final int C2_SECTIONING_CHAPTER = 38;
    public static final int C2_SECTIONING_SECTION = 54;
    public static final int C2_SECTIONING_SUBSECTION = 70;
    public static final int C2_SECTIONING_SUBSUBSECTION = 86;
    public static final int LABEL = 7;
    public static final int C2_LABEL_REFLABEL = 23;
    public static final int C3_LABEL_REFLABEL_DEF = 279;
    public static final int C3_LABEL_REFLABEL_REF = 1815;
    public static final int C2_LABEL_COUNTER = 119;
    public static final int C3_LABEL_COUNTER_DEF = 375;
    public static final int C3_LABEL_COUNTER_REF = 1911;
    public static final int STYLE = 8;
    public static final int C2_STYLE_TEXT = 56;
    public static final int C3_STYLE_TEXT_FONT_O = 312;
    public static final int C3_STYLE_TEXT_FONT_B = 568;
    public static final int C3_STYLE_TEXT_SIZE_O = 824;
    public static final int C2_STYLE_MATH = 88;
    public static final int SYMBOL = 10;
    public static final int C2_SYMBOL_COMMON = 26;
    public static final int C2_SYMBOL_CHAR = 42;
    public static final int C2_SYMBOL_TEXT = 58;
    public static final int MATHSYMBOL = 11;
    public static final int C2_MATHSYMBOL_GREEK = 27;
    public static final int C3_MATHSYMBOL_GREEK_UPPER = 283;
    public static final int C3_MATHSYMBOL_GREEK_LOWER = 539;
    public static final int C2_MATHSYMBOL_OP = 91;
    public static final int C3_MATHSYMBOL_OP_BIN = 347;
    public static final int C3_MATHSYMBOL_OP_ROOTFRAC = 603;
    public static final int C3_MATHSYMBOL_OP_RELSTD = 859;
    public static final int C3_MATHSYMBOL_OP_RELARROW = 1115;
    public static final int C3_MATHSYMBOL_OP_RELMISC = 1627;
    public static final int C3_MATHSYMBOL_OP_LARGE = 1883;
    public static final int C3_MATHSYMBOL_OP_NAMED = 2907;
    public static final int C2_MATHSYMBOL_MISC = 107;
    public static final int C3_MATHSYMBOL_MISC_ALPHA = 363;
    public static final int C3_MATHSYMBOL_MISC_ORD = 619;
    public static final int C3_MATHSYMBOL_DOTS = 1643;
    public static final int C3_MATHSYMBOL_ACCENTS_ = 1899;
    public static final int C2_MATHSYMBOL_BRACKETS = 123;
    public static final int C3_MATHSYMBOL_BRACKETS_ = 91;
    public static final int ELEMENT = 12;
    public static final int C2_ELEMENT_GRAPHIC = 140;
    public static final int C3_ELEMENT_GRAPHIC_PICTURE = 652;
    public static final int C3_ELEMENT_GRAPHIC_DRAW = 1164;
    public static final int BIB = 13;
    public static final int C2_BIB_DEF = 29;
    public static final int C2_BIB_REF = 45;
    public static final int C2_BIB_INCLUDE = 61;
    private static final List<Argument> NO_ARGUMENTS = Collections.emptyList();
    static final Collator COLLATOR = Collator.getInstance((Locale)Locale.ENGLISH);
    private final int type;
    private final String word;
    private final boolean supportAserisk;
    private final List<Argument> arguments;
    private final String description;
    private final @Nullable TexPackage texPackage;

    static {
        ((RuleBasedCollator)COLLATOR).setUpperCaseFirst(true);
    }

    public TexCommand(int type, String word, boolean asterisk, List<Argument> arguments, @Nullable TexPackage texPackage, String description) {
        this.type = type;
        this.word = word;
        this.supportAserisk = asterisk;
        this.arguments = arguments;
        this.texPackage = texPackage;
        this.description = description;
    }

    public TexCommand(int type, String word, boolean asterisk, List<Argument> arguments, String description) {
        this(type, word, asterisk, arguments, null, description);
    }

    public TexCommand(int type, String word, String description) {
        this(type, word, false, NO_ARGUMENTS, null, description);
    }

    public int getType() {
        return this.type;
    }

    public String getControlWord() {
        return this.word;
    }

    public boolean supportAsterisk() {
        return this.supportAserisk;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public @Nullable TexPackage getPackage() {
        return this.texPackage;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(TexCommand other) {
        return COLLATOR.compare(this.word, other.word);
    }

    public String toString() {
        return this.word;
    }
}

