/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusLogger;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.status.util.StatusPrinter;

@NonNullByDefault
public class ACommonsLoggingStatusLogger
implements StatusLogger {
    private static final Function<String, Log> CREATE_LOG_FUNCTION = LogFactory::getLog;
    private final ConcurrentHashMap<String, Log> logs = new ConcurrentHashMap();
    private final StatusPrinter logStatusPrinter = new StatusPrinter();

    @Override
    public void log(Status status) {
        Log log = this.logs.computeIfAbsent(status.getBundleId(), CREATE_LOG_FUNCTION);
        switch (status.getSeverity()) {
            case 4: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)this.createMessage(status), status.getException());
                break;
            }
            case 2: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)this.createMessage(status), status.getException());
                break;
            }
            default: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)this.createMessage(status), status.getException());
            }
        }
    }

    protected String createMessage(Status status) {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder();
        sb.append('[', status.getCode(), ']');
        switch (status.getSeverity()) {
            case 0: 
            case 8: {
                sb.append(' ', Statuses.getSeverityString(status.getSeverity()));
                break;
            }
        }
        sb.appendLines(' ', status.getMessage());
        if (status.isMultiStatus()) {
            ImList<Status> children = status.getChildren();
            if (children != null && !children.isEmpty()) {
                StringBuilder sb0 = new StringBuilder();
                sb0.append("Status:\n");
                this.logStatusPrinter.print(children, sb0);
                sb.addProp("children", sb0.toString());
            } else {
                sb.addProp("children", "<none>");
            }
        }
        return sb.toString();
    }
}

