/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RComplexStore;
import org.eclipse.statet.rj.data.impl.AbstractRStore;

@NonNullByDefault
public abstract class AbstractComplexStore
extends AbstractRStore<RComplexStore.Complex>
implements RComplexStore {
    protected static final String toChar(double real, double imaginary) {
        StringBuilder sb = new StringBuilder();
        if (real == Double.POSITIVE_INFINITY) {
            sb.append("Inf");
        } else if (real == Double.NEGATIVE_INFINITY) {
            sb.append("-Inf");
        } else {
            sb.append(real);
        }
        if (imaginary == Double.POSITIVE_INFINITY) {
            sb.append("+Infi");
        } else if (imaginary == Double.NEGATIVE_INFINITY) {
            sb.append("-Infi");
        } else if (Double.isNaN(imaginary)) {
            sb.append("+NaNi");
        } else if (imaginary >= 0.0) {
            sb.append('+');
            sb.append(imaginary);
            sb.append('i');
        } else {
            sb.append(imaginary);
            sb.append('i');
        }
        return sb.toString();
    }

    @Override
    public final byte getStoreType() {
        return 4;
    }

    @Override
    public final String getBaseVectorRClassName() {
        return "complex";
    }

    @Override
    public final String getChar(int idx) {
        return AbstractComplexStore.toChar(this.getCplxRe(idx), this.getCplxIm(idx));
    }

    @Override
    public final String getChar(long idx) {
        return AbstractComplexStore.toChar(this.getCplxRe(idx), this.getCplxIm(idx));
    }

    @Override
    public long indexOf(int integer, long fromIdx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract @Nullable RComplexStore.Complex[] toArray();
}

