/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class WidgetToolsButton
extends Composite {
    static final String FONT_SYMBOLIC_NAME = "org.eclipse.statet.ecommons.ToolButtonFont";
    private Button fButton;
    private Menu fMenu;
    private final Control fTarget;

    static Font getToolButtonFont() {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        if (!fontRegistry.hasValueFor(FONT_SYMBOLIC_NAME)) {
            fontRegistry.addListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.jface.dialogfont")) {
                        WidgetToolsButton.updateFont();
                    }
                }
            });
            WidgetToolsButton.updateFont();
        }
        return fontRegistry.get(FONT_SYMBOLIC_NAME);
    }

    private static void updateFont() {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        Font dialogFont = fontRegistry.get("org.eclipse.jface.dialogfont");
        int size = 1 + Math.max(dialogFont.getFontData()[0].getHeight() * 3 / 5, 6);
        FontDescriptor descriptor = fontRegistry.getDescriptor("org.eclipse.jface.textfont").setHeight(size);
        Font toolFont = descriptor.createFont((Device)Display.getCurrent());
        fontRegistry.put(FONT_SYMBOLIC_NAME, toolFont.getFontData());
    }

    public WidgetToolsButton(Control target) {
        super(target.getParent(), 0);
        this.setLayout((Layout)new FillLayout());
        this.fTarget = target;
        this.createButton();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fButton.setFont(WidgetToolsButton.getToolButtonFont());
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point computeSize = super.computeSize(hint, hint2, changed);
        int x = Math.max(computeSize.x, 18);
        int y = Math.min(Math.max(computeSize.y, 18), this.fTarget.computeSize((int)-1, (int)-1, (boolean)changed).y);
        return new Point(x, y);
    }

    protected void createButton() {
        this.fButton = new Button((Composite)this, 0x1000008);
        this.updateLabels(false);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WidgetToolsButton.this.showMenu();
            }
        });
        this.fButton.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '+') {
                    WidgetToolsButton.this.showMenu();
                }
            }
        });
        this.fTarget.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                WidgetToolsButton.this.updateLabels(true);
            }

            public void focusLost(FocusEvent e) {
                WidgetToolsButton.this.updateLabels(false);
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetToolsButton.this.disposeMenu();
            }
        });
        this.setFont(null);
    }

    public Control getButton() {
        return this.fButton;
    }

    public void showMenu() {
        if (this.fMenu == null) {
            this.fMenu = new Menu((Control)this.fButton);
            this.fillMenu(this.fMenu);
        }
        Rectangle bounds = this.fButton.getBounds();
        Point pos = this.fButton.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
        this.fMenu.setLocation(pos);
        this.fMenu.setVisible(true);
    }

    public void resetMenu() {
        this.disposeMenu();
    }

    protected void disposeMenu() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    protected void updateLabels(boolean hasFocus) {
        this.fButton.setText(hasFocus ? "&+" : "+");
    }

    protected void fillMenu(Menu menu) {
    }
}

