/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.swt;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

@NonNullByDefault
public class ColorUtils {
    private static int blend(int v1, int v2, float ratio) {
        int b = Math.round(ratio * (float)v1 + (1.0f - ratio) * (float)v2);
        return Math.min(255, b);
    }

    public static RGB blend(RGB c1, RGB c2, float ratio) {
        return new RGB(ColorUtils.blend(c1.red, c2.red, ratio), ColorUtils.blend(c1.green, c2.green, ratio), ColorUtils.blend(c1.blue, c2.blue, ratio));
    }

    public static Color blend(Color c1, Color c2, float ratio) {
        return new Color(ColorUtils.blend(c1.getRed(), c2.getRed(), ratio), ColorUtils.blend(c1.getGreen(), c2.getGreen(), ratio), ColorUtils.blend(c1.getBlue(), c2.getBlue(), ratio));
    }

    private ColorUtils() {
    }
}

