/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldTermStack;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class Highlighter
extends FastVectorHighlighter {
    public static final Encoder DEFAULT_ENCODER = new DefaultEncoder();
    private final FragListBuilder fragListBuilder;
    private final FragmentsBuilder fragmentsBuilder;

    private static String getTag(String[] tags, int num) {
        return tags[num % tags.length];
    }

    private static int countMatches(List<FieldFragList.WeightedFragInfo> fragInfos) {
        int matchCount = 0;
        int j = 0;
        while (j < fragInfos.size()) {
            matchCount += fragInfos.get(j).getSubInfos().size();
            ++j;
        }
        return matchCount;
    }

    public Highlighter(boolean phraseHighlight, boolean fieldMatch, FragListBuilder fragListBuilder, FragmentsBuilder fragmentsBuilder) {
        super(phraseHighlight, fieldMatch, fragListBuilder, fragmentsBuilder);
        this.fragListBuilder = fragListBuilder;
        this.fragmentsBuilder = fragmentsBuilder;
    }

    public String getComplete(FieldQuery fieldQuery, IndexReader reader, int docId, String fieldName, String[] preTags, String[] postTags, Encoder encoder) throws IOException {
        FieldTermStack fieldTermStack = new FieldTermStack(reader, docId, fieldName, fieldQuery);
        FieldPhraseList fieldPhraseList = new FieldPhraseList(fieldTermStack, fieldQuery);
        String src = reader.document(docId).get(fieldName);
        int srcIndex = 0;
        StringBuilder sb = new StringBuilder(src.length() + fieldPhraseList.getPhraseList().size() * 32);
        for (FieldPhraseList.WeightedPhraseInfo phraseInfo : fieldPhraseList.getPhraseList()) {
            for (FieldPhraseList.WeightedPhraseInfo.Toffs to : phraseInfo.getTermsOffsets()) {
                sb.append(encoder.encodeText(src.substring(srcIndex, to.getStartOffset())));
                sb.append(Highlighter.getTag(preTags, phraseInfo.getSeqnum()));
                sb.append(encoder.encodeText(src.substring(to.getStartOffset(), to.getEndOffset())));
                sb.append(Highlighter.getTag(postTags, phraseInfo.getSeqnum()));
                srcIndex = to.getEndOffset();
            }
        }
        sb.append(encoder.encodeText(src.substring(srcIndex)));
        return sb.toString();
    }

    public final String @Nullable [] getBestFragments(FieldQuery fieldQuery, IndexReader reader, int docId, String fieldName, int fragCharSize, int maxNumFragments, String[] preTags, String[] postTags, Encoder encoder, @Nullable AtomicInteger counter) throws IOException {
        FieldTermStack fieldTermStack = new FieldTermStack(reader, docId, fieldName, fieldQuery);
        FieldPhraseList fieldPhraseList = new FieldPhraseList(fieldTermStack, fieldQuery, this.getPhraseLimit());
        FieldFragList fieldFragList = this.fragListBuilder.createFieldFragList(fieldPhraseList, fragCharSize);
        if (counter != null) {
            int matchCount = Highlighter.countMatches(fieldFragList.getFragInfos());
            if (matchCount == 0) {
                return null;
            }
            counter.addAndGet(matchCount);
        }
        return this.fragmentsBuilder.createFragments(reader, docId, fieldName, fieldFragList, maxNumFragments, preTags, postTags, encoder);
    }
}

